/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems.implementation;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.gems.implementation.ReturnWeaponTask;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class ThrowWeaponTask
extends BukkitRunnable {
    private final ArmorStand armorStand;
    private final Player player;
    private final ItemStack itemStack;
    private final boolean rotateWeapon;
    private final boolean isTriWeapon;
    private final boolean isRetaliated;
    private final ReturnWeaponTask returnWeaponTask;
    private Vector vector;

    public ThrowWeaponTask(Player player, ItemStack itemStack, boolean rotateWeapon, boolean isTriWeapon, boolean returnWeapon) {
        this(player, itemStack, rotateWeapon, isTriWeapon, returnWeapon, new Vector(0, 0, 0));
    }

    public ThrowWeaponTask(Player player, ItemStack itemStack, boolean rotateWeapon, boolean isTriWeapon, boolean isRetaliated, Vector vector) {
        this.player = player;
        this.itemStack = itemStack;
        this.rotateWeapon = rotateWeapon;
        this.isTriWeapon = isTriWeapon;
        this.isRetaliated = isRetaliated;
        this.vector = vector;
        this.armorStand = this.spawnArmorstand(player, itemStack);
        this.returnWeaponTask = new ReturnWeaponTask(this.getItemStack(), this.getArmorStand(), this.getPlayer());
    }

    public ArmorStand spawnArmorstand(Player player, ItemStack itemStack) {
        return (ArmorStand)player.getWorld().spawn(player.getLocation().add(0.0, 0.9, 0.0), ArmorStand.class, armorStand -> {
            armorStand.setArms(true);
            armorStand.setGravity(false);
            armorStand.setVisible(false);
            armorStand.setSmall(true);
            armorStand.setMarker(true);
            armorStand.setCustomNameVisible(false);
            armorStand.setPersistent(false);
            this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_WITCH_THROW, 1.0f, 1.0f);
            if (this.isTriWeapon()) {
                armorStand.setRightArmPose(Utils.setRightArmAngle(armorStand, 0, 0, 0));
                Objects.requireNonNull(armorStand.getEquipment()).setItemInMainHand(itemStack.clone());
                Objects.requireNonNull(armorStand.getEquipment()).setItemInOffHand(itemStack.clone());
                Objects.requireNonNull(armorStand.getEquipment()).setHelmet(itemStack.clone());
            } else {
                armorStand.setRightArmPose(Utils.setRightArmAngle(armorStand, 270, 0, 0));
                Objects.requireNonNull(armorStand.getEquipment()).setItemInMainHand(itemStack.clone());
            }
        });
    }

    public void run() {
        this.getArmorStand().teleport(this.getArmorStand().getLocation().add(this.getVector()));
        if (this.isRotateWeapon()) {
            this.getArmorStand().setRightArmPose(Utils.setRightArmAngle(this.getArmorStand(), 45, 0, 0));
        }
        RayTraceResult result = this.getArmorStand().rayTraceBlocks(0.109);
        List entityList = this.getArmorStand().getNearbyEntities(0.3, 0.3, 0.3);
        if (result != null && Objects.requireNonNull(result.getHitBlock()).getType() != Material.GRASS && !Tag.FLOWERS.isTagged((Keyed)result.getHitBlock().getType())) {
            if (this.shouldReturnWeapon(false)) {
                return;
            }
            this.dropWeapon();
            return;
        }
        if (!entityList.isEmpty() && !entityList.contains(this.getPlayer())) {
            for (int i = 0; i < entityList.size(); ++i) {
                if (!(entityList.get(i) instanceof Damageable) || ((Entity)entityList.get(i)).getUniqueId() == this.getPlayer().getUniqueId()) continue;
                if (WeaponArmorEnum.SWORDS.isTagged(this.getItemStack().clone().getType())) {
                    ((Damageable)entityList.get(i)).damage(ThreadLocalRandom.current().nextInt(100) < 35 ? 8.0 : 5.0, (Entity)this.getPlayer());
                    continue;
                }
                ((Damageable)entityList.get(i)).damage(ThreadLocalRandom.current().nextInt(100) < 35 ? 10.0 : 6.0, (Entity)this.getPlayer());
            }
            if (this.shouldReturnWeapon(true)) {
                return;
            }
            if (!this.isTriWeapon()) {
                this.dropWeapon();
                return;
            }
        }
        if (this.getArmorStand().getLocation().distanceSquared(this.getPlayer().getLocation()) > 3600.0) {
            this.getPlayer().sendMessage(Utils.colorTranslator("&eYour weapon has reached the max distance of 60 blocks!"));
            if (this.shouldReturnWeapon(false)) {
                return;
            }
            this.dropWeapon();
        }
    }

    public boolean shouldReturnWeapon(boolean entityHit) {
        if (!this.isRetaliated() || this.isTriWeapon() && entityHit) {
            return false;
        }
        this.returnWeapon();
        return true;
    }

    public void dropWeapon() {
        this.cancel();
        Item droppedItem = this.getArmorStand().getWorld().dropItem(this.getArmorStand().getLocation(), this.getItemStack().clone());
        Location locInfo = droppedItem.getLocation();
        droppedItem.setOwner(this.getPlayer().getUniqueId());
        droppedItem.setGlowing(true);
        this.getArmorStand().remove();
        this.getPlayer().sendMessage(Utils.colorTranslator("&6Weapon dropped near at x: " + (int)locInfo.getX() + ", y: " + (int)locInfo.getY() + ", z: " + (int)locInfo.getZ()));
    }

    public void returnWeapon() {
        this.cancel();
        this.getReturnWeaponTask().runTaskTimer((Plugin)FNAmplifications.getInstance(), 4L, 1L);
    }

    public void centeredThrow() {
        this.getArmorStand().teleport(this.getPlayer().getLocation().add(0.0, 0.9, 0.0));
    }

    public void resetArmorstandArmPos() {
        this.getArmorStand().setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean isRotateWeapon() {
        return this.rotateWeapon;
    }

    public boolean isTriWeapon() {
        return this.isTriWeapon;
    }

    public boolean isRetaliated() {
        return this.isRetaliated;
    }

    public ReturnWeaponTask getReturnWeaponTask() {
        return this.returnWeaponTask;
    }

    public Vector getVector() {
        return this.vector;
    }

    public void setVector(Vector vector) {
        this.vector = vector;
    }
}

