/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.integrations;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.util.Optional;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultIntegration {
    private final SlimefunAddon slimefunAddon;
    private boolean isVaultInstalled;
    private Economy economy = null;

    public VaultIntegration(SlimefunAddon addon) {
        this.slimefunAddon = addon;
        if (!this.setupEconomy()) {
            this.getSlimefunAddon().getLogger().info("Vault not detected! Successfully unregistered items that need vault.");
        } else {
            this.getSlimefunAddon().getLogger().info("Vault detected! Successfully registered items that need vault.");
        }
    }

    public boolean setupEconomy() {
        if (!this.getSlimefunAddon().getJavaPlugin().getServer().getPluginManager().isPluginEnabled("Vault")) {
            this.isVaultInstalled = false;
            return false;
        }
        try {
            Optional<RegisteredServiceProvider> economyRegisteredServiceProvider = Optional.ofNullable(this.getSlimefunAddon().getJavaPlugin().getServer().getServicesManager().getRegistration(Economy.class));
            if (economyRegisteredServiceProvider.isPresent()) {
                this.economy = (Economy)economyRegisteredServiceProvider.get().getProvider();
                this.isVaultInstalled = true;
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            this.isVaultInstalled = false;
            return false;
        }
        this.isVaultInstalled = false;
        return false;
    }

    public SlimefunAddon getSlimefunAddon() {
        return this.slimefunAddon;
    }

    public boolean isVaultInstalled() {
        return this.isVaultInstalled;
    }

    public Economy getEconomy() {
        return this.economy;
    }
}

