/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.machines;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import ne.fnfal113.fnamplifications.ExtraUtils.interfaces.InventoryBlock;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Dispenser;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ElectricBlockBreaker
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent {
    public static final Map<Location, BlockBreakerCache> CACHE_MAP = new HashMap<Location, BlockBreakerCache>();
    public static final int CHANGE_MODE = 0;
    public static final int ON_OFF = 8;
    private static final ItemStack VERSIONED_AMETHYST;
    private static final CustomItemStack NOT_OPERATING;
    private static final CustomItemStack NO_POWER;
    private static final CustomItemStack NOT_RUNNING;
    private static final CustomItemStack BREAK_BLOCK_NATURALLY;
    private static final CustomItemStack DROP_BLOCK_NATURALLY;
    private static final CustomItemStack TOGGLED_ON;
    private static final CustomItemStack TOGGLED_OFF;
    public static final ItemStack DUMMY_PICK;
    public static final ItemStack DUMMY_SILK_PICK;
    private static final Set<Material> ILLEGAL;
    private int energyCapacity = -1;
    private int energyConsumedPerTick = -1;
    private int rate = 2;

    @ParametersAreNonnullByDefault
    public ElectricBlockBreaker(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int tickRate) {
        super(itemGroup, item, recipeType, recipe);
        FNAmplifications.getInstance().getConfigManager().initializeConfig(this.getId(), "tickrate", tickRate, "block-breaker-tickrate");
        this.setRate();
        Utils.setLoreByIntValue(this.getItem(), this.getId(), "tickrate", "ticks", "&e", " ticks", "block-breaker-tickrate");
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            @ParametersAreNonnullByDefault
            public void tick(Block block, SlimefunItem slimefunItem, Config data) {
                ElectricBlockBreaker.this.onTick(block);
            }
        }, new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent event) {
                BlockStorage.addBlockInfo((Block)event.getBlock(), (String)"owner", (String)event.getPlayer().getUniqueId().toString());
            }
        }});
        this.createPreset(this, this.getInventoryTitle(), blockMenuPreset -> {
            for (int i = 0; i < 9; ++i) {
                blockMenuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            blockMenuPreset.addItem(4, (ItemStack)NO_POWER);
        });
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                for (int i = 0; i < 9; ++i) {
                    this.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
                }
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return ElectricBlockBreaker.this.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[]{0};
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                String breakMode = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"breakBlockNaturally");
                String isRunning = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"toggled_On");
                String owner = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"owner");
                boolean currentMode = false;
                if (breakMode != null) {
                    currentMode = Boolean.parseBoolean(breakMode);
                }
                menu.replaceExistingItem(0, (ItemStack)(currentMode ? BREAK_BLOCK_NATURALLY : DROP_BLOCK_NATURALLY));
                menu.addMenuClickHandler(0, (p, slot, item, action) -> {
                    ElectricBlockBreaker.this.toggleMode(menu);
                    return false;
                });
                boolean isOn = false;
                if (isRunning != null) {
                    isOn = Boolean.parseBoolean(isRunning);
                }
                menu.replaceExistingItem(8, (ItemStack)(isOn ? TOGGLED_ON : TOGGLED_OFF));
                menu.addMenuClickHandler(8, (p, slot, item, action) -> {
                    ElectricBlockBreaker.this.toggleOnOrOff(menu);
                    return false;
                });
                UUID ownerUUID = null;
                if (owner != null) {
                    ownerUUID = UUID.fromString(owner);
                }
                BlockBreakerCache cache = new BlockBreakerCache(0, currentMode, isOn, ownerUUID);
                CACHE_MAP.put(menu.getLocation(), cache);
            }
        };
    }

    public void onTick(@Nonnull Block b) {
        BlockMenu invMenu = BlockStorage.getInventory((Block)b);
        if (!(b.getBlockData() instanceof Dispenser)) {
            return;
        }
        Dispenser dispenser = (Dispenser)b.getBlockData();
        Block targetBlock = b.getRelative(dispenser.getFacing());
        World targetLocation = targetBlock.getWorld();
        BlockBreakerCache cache = CACHE_MAP.get(b.getLocation());
        if (this.getCharge(b.getLocation()) > 0) {
            invMenu.replaceExistingItem(4, (ItemStack)NOT_RUNNING);
            if (cache.isOn) {
                invMenu.replaceExistingItem(4, (ItemStack)NOT_OPERATING);
                if (targetBlock.getType().isSolid() && !ILLEGAL.contains(targetBlock.getType()) && !BlockStorage.hasBlockInfo((Block)targetBlock)) {
                    if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)cache.owner), targetBlock, Interaction.BREAK_BLOCK)) {
                        return;
                    }
                    int progress = cache.progress;
                    if (invMenu.hasViewer()) {
                        invMenu.replaceExistingItem(4, (ItemStack)new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, "&aOperating!", new String[]{"", "&bRate: " + this.rate + " ticks per Block", "&2Breaking block at rate: " + progress + "/" + this.rate}));
                    }
                    if (progress >= this.rate) {
                        progress = 0;
                        if (cache.breakNaturally) {
                            targetBlock.breakNaturally(DUMMY_PICK);
                        } else {
                            ItemStack vanilla = new ItemStack(targetBlock.getType());
                            if (vanilla.isSimilar(VERSIONED_AMETHYST)) {
                                targetBlock.setType(Material.AIR);
                            } else {
                                targetBlock.breakNaturally(DUMMY_SILK_PICK);
                            }
                        }
                        targetLocation.playSound(b.getLocation().add(0.5, 0.5, 0.5), Sound.UI_STONECUTTER_TAKE_RESULT, 1.0f, 1.0f);
                        b.getWorld().spawnParticle(Particle.SMOKE_LARGE, b.getLocation().add(1.0, 1.0, 1.0), 2, 0.1, 0.1, 0.1);
                    } else {
                        ++progress;
                        targetLocation.playSound(b.getLocation().add(0.5, 0.5, 0.5), Sound.BLOCK_STONE_HIT, 1.0f, 1.0f);
                    }
                    cache.progress = progress;
                    CACHE_MAP.put(invMenu.getLocation(), cache);
                    this.takeCharge(b.getLocation());
                }
            }
        }
    }

    public void toggleMode(BlockMenu blockMenu) {
        BlockBreakerCache cache;
        Location location = blockMenu.getLocation();
        cache.breakNaturally = !(cache = CACHE_MAP.get(location)).breakNaturally;
        BlockStorage.addBlockInfo((Location)location, (String)"breakBlockNaturally", (String)String.valueOf(cache.breakNaturally));
        blockMenu.replaceExistingItem(0, (ItemStack)(cache.breakNaturally ? BREAK_BLOCK_NATURALLY : DROP_BLOCK_NATURALLY));
        CACHE_MAP.put(location, cache);
    }

    public void toggleOnOrOff(BlockMenu blockMenu) {
        BlockBreakerCache cache;
        Location location = blockMenu.getLocation();
        cache.isOn = !(cache = CACHE_MAP.get(location)).isOn;
        BlockStorage.addBlockInfo((Location)location, (String)"toggled_On", (String)String.valueOf(cache.isOn));
        blockMenu.replaceExistingItem(8, (ItemStack)(cache.isOn ? TOGGLED_ON : TOGGLED_OFF));
        CACHE_MAP.put(location, cache);
    }

    public final void setRate() {
        this.rate = FNAmplifications.getInstance().getConfigManager().getCustomConfig("block-breaker-tickrate").getInt(this.getId() + ".tickrate");
    }

    @Nonnull
    public String getInventoryTitle() {
        return this.getItemName();
    }

    @Override
    public int[] getInputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getEnergyConsumption() {
        return this.energyConsumedPerTick;
    }

    public final ElectricBlockBreaker setEnergyConsumption(int energyConsumption) {
        Validate.isTrue((energyConsumption > 0 ? 1 : 0) != 0, (String)"The energy consumption must be greater than zero!");
        Validate.isTrue((this.energyCapacity > 0 ? 1 : 0) != 0, (String)"You must specify the capacity before you can set the consumption amount.");
        Validate.isTrue((energyConsumption <= this.energyCapacity ? 1 : 0) != 0, (String)("The energy consumption cannot be higher than the capacity (" + this.energyCapacity + ')'));
        this.energyConsumedPerTick = energyConsumption;
        return this;
    }

    public int getCapacity() {
        return this.energyCapacity;
    }

    public final ElectricBlockBreaker setCapacity(int capacity) {
        Validate.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"The capacity must be greater than zero!");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    public boolean takeCharge(@Nonnull Location l) {
        if (this.isChargeable()) {
            int charge = this.getCharge(l);
            if (charge < this.getEnergyConsumption()) {
                return false;
            }
            this.setCharge(l, charge - this.getEnergyConsumption());
            return true;
        }
        return true;
    }

    static {
        NOT_OPERATING = new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, "&cNot Operating...", new String[]{"&ePlace a block facing the dispenser!"});
        NO_POWER = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cNo Power!", new String[]{"&ePower it up first!"});
        NOT_RUNNING = new CustomItemStack(Material.YELLOW_STAINED_GLASS_PANE, "&cNot Running", new String[]{"&eToggle it on first"});
        BREAK_BLOCK_NATURALLY = new CustomItemStack(Material.PINK_STAINED_GLASS_PANE, "&d&lMode:", new String[]{"&eBreak block naturally (No Silk Touch)", "Click to change"});
        DROP_BLOCK_NATURALLY = new CustomItemStack(Material.CYAN_STAINED_GLASS_PANE, "&d&lMode:", new String[]{"&eDrop block naturally (Silk Touch)", "Click to change"});
        TOGGLED_ON = new CustomItemStack(Material.BLUE_STAINED_GLASS_PANE, "&d&lToggle:", new String[]{"&eEnabled (Running)", "Click to change"});
        TOGGLED_OFF = new CustomItemStack(Material.WHITE_STAINED_GLASS_PANE, "&d&lToggle:", new String[]{"&eDisabled (Not Running)", "Click to change"});
        DUMMY_PICK = new ItemStack(Material.DIAMOND_PICKAXE);
        DUMMY_SILK_PICK = new ItemStack(Material.DIAMOND_PICKAXE);
        ILLEGAL = EnumSet.of(Material.BEDROCK, Material.END_PORTAL_FRAME, Material.FROSTED_ICE, Material.BARRIER, Material.END_GATEWAY);
        VERSIONED_AMETHYST = Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_17) ? new ItemStack(Material.BUDDING_AMETHYST) : new ItemStack(Material.BEDROCK);
        ItemMeta meta = DUMMY_SILK_PICK.getItemMeta();
        meta.addEnchant(Enchantment.SILK_TOUCH, 1, true);
        DUMMY_SILK_PICK.setItemMeta(meta);
        ILLEGAL.addAll(Tag.BEDS.getValues());
        ILLEGAL.addAll(Tag.DOORS.getValues());
    }

    public static class BlockBreakerCache {
        private int progress;
        private boolean breakNaturally;
        private boolean isOn;
        private final UUID owner;

        public BlockBreakerCache(int progress, boolean breakNaturally, boolean isOn, @Nullable UUID owner) {
            this.progress = progress;
            this.breakNaturally = breakNaturally;
            this.isOn = isOn;
            this.owner = owner;
        }
    }
}

