/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.utils.pdc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ItemStackPdcType<T, Z>
implements PersistentDataType<byte[], ItemStack> {
    private final Class<T> primitive;
    private final Class<Z> complex;
    public static final PersistentDataType<byte[], ItemStack> ITEM_STACK_PDC = new ItemStackPdcType<byte[], ItemStack>(byte[].class, ItemStack.class);

    @Nonnull
    public Class<byte[]> getPrimitiveType() {
        return this.primitive;
    }

    @Nonnull
    public Class<ItemStack> getComplexType() {
        return this.complex;
    }

    @Nonnull
    public byte[] toPrimitive(@Nonnull ItemStack itemStack, @Nonnull PersistentDataAdapterContext context) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (BukkitObjectOutputStream inputStream = new BukkitObjectOutputStream((OutputStream)new BufferedOutputStream(bytes));){
            inputStream.writeObject((Object)itemStack);
        }
        catch (IOException | NullPointerException | SecurityException e) {
            e.printStackTrace();
        }
        return bytes.toByteArray();
    }

    @Nonnull
    public ItemStack fromPrimitive(@Nonnull byte[] primitive, @Nonnull PersistentDataAdapterContext context) {
        ItemStack itemStack;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(primitive);
        BukkitObjectInputStream bytes = new BukkitObjectInputStream((InputStream)new BufferedInputStream(inputStream));
        try {
            itemStack = (ItemStack)bytes.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytes.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassCastException e) {
                e.printStackTrace();
                return new ItemStack(Material.AIR);
            }
        }
        bytes.close();
        return itemStack;
    }

    public ItemStackPdcType(Class<T> primitive, Class<Z> complex) {
        this.primitive = primitive;
        this.complex = complex;
    }
}

