/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems.abstracts;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.io.IOException;
import java.util.UUID;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.gems.handlers.GemHandler;
import ne.fnfal113.fnamplifications.gems.implementation.GemKeysEnum;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractGem
extends SlimefunItem
implements GemHandler {
    private int chance;

    public AbstractGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        this(itemGroup, item, recipeType, recipe, 0);
    }

    public AbstractGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int defaultChance) {
        super(itemGroup, item, recipeType, recipe);
        this.initializeSettings(defaultChance);
        GemKeysEnum.GEM_KEYS_ENUM.getGEM_KEYS().add(Keys.createKey(this.getId().toLowerCase()));
    }

    public void initializeSettings(int defaultChance) {
        if (defaultChance != 0) {
            this.setConfigChanceValues(defaultChance);
            this.setConfigWorldSettings();
            Utils.upgradeGemLore(this.getItem(), this.getItem().getItemMeta(), this.getId(), "chance", "%", "&e", "%", 4);
            this.chance = FNAmplifications.getInstance().getConfigManager().getIntValueById(this.getId(), "chance");
        } else {
            this.setConfigWorldSettings();
        }
    }

    public void setConfigChanceValues(int chance) throws IOException {
        FNAmplifications.getInstance().getConfigManager().setConfigIntegerValues(this.getId(), "chance", chance, "gem-settings", true);
    }

    public void setConfigWorldSettings() throws IOException {
        for (World world : Bukkit.getWorlds()) {
            FNAmplifications.getInstance().getConfigManager().setConfigBooleanValues(this.getId() + ".world-settings", world.getName() + "_enable", true, "gem-settings", true);
        }
    }

    public boolean isEnabledInCurrentWorld(String gemID, String worldName) {
        return FNAmplifications.getInstance().getConfigManager().getBoolById(gemID + ".world-settings", worldName + "_enable");
    }

    public void sendGemMessage(Player player, String gemName) {
        player.sendMessage(Utils.colorTranslator("&6" + gemName + " has taken effect!"));
    }

    public boolean hasPermissionToThrow(Player player) {
        return Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), player.getLocation(), Interaction.INTERACT_BLOCK);
    }

    public abstract void onDrag(InventoryClickEvent var1, Player var2, SlimefunItem var3, ItemStack var4);

    public int getChance() {
        return this.chance;
    }
}

