/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gears.abstracts;

import com.google.gson.JsonObject;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.io.IOException;
import java.util.UUID;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.config.ConfigManager;
import ne.fnfal113.fnamplifications.gears.implementation.GearTask;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AbstractGears
extends SlimefunItem {
    private final NamespacedKey defaultUsageKey;
    private final NamespacedKey defaultUsageKey2;
    private final NamespacedKey defaultUsageKey3;
    private final int startingProgress;
    private final int incrementingProgress;
    private final int maxLevel;
    private final int maxAttributes;
    private final EquipmentSlot equipmentSlot;
    private final GearTask gearTask;
    private final ConfigManager configManager = FNAmplifications.getInstance().getConfigManager();

    public AbstractGears(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, NamespacedKey defaultUsageKey, NamespacedKey defaultUsageKey2, NamespacedKey defaultUsageKey3, int startingProgress, int incrementingProgress, int maxLevel, int maxAttributes, EquipmentSlot equipmentSlot) {
        super(itemGroup, item, recipeType, recipe);
        this.initializeSettings(maxLevel, maxAttributes);
        this.defaultUsageKey = defaultUsageKey;
        this.defaultUsageKey2 = defaultUsageKey2;
        this.defaultUsageKey3 = defaultUsageKey3;
        this.startingProgress = startingProgress;
        this.incrementingProgress = incrementingProgress;
        this.maxLevel = this.configManager.getIntValueById(this.getId(), "max-level");
        this.maxAttributes = this.configManager.getIntValueById(this.getId(), "max-attributes");
        this.equipmentSlot = equipmentSlot;
        this.gearTask = new GearTask(this.getDefaultUsageKey(), this.getDefaultUsageKey2(), this.getDefaultUsageKey3(), (ItemStack)item, startingProgress, incrementingProgress, this.getMaxLevel());
    }

    public void initializeSettings(int maxLevel, int maxAttributes) {
        try {
            this.configManager.setConfigBooleanValues(this.getId(), "unbreakable", false, "fn-gear-unbreakable-settings", true);
            this.configManager.setConfigIntegerValues(this.getId(), "max-level", maxLevel, "fn-gear-level-settings", false);
            this.configManager.setConfigIntegerValues(this.getId(), "max-attributes", maxAttributes, "fn-gear-level-settings", false);
            JsonObject jsonObject = (JsonObject)this.configManager.loadJson(this.getId().toLowerCase() + "_default_ench");
            int configMaxLevel = this.configManager.getIntValueById(this.getId(), "max-level");
            for (int i = 1; i <= Math.max(configMaxLevel, maxLevel); ++i) {
                String section = this.getId() + ".level-" + i;
                this.initializeEnchants(section, i, jsonObject);
                if (i % 5 != 0) continue;
                this.initializeAttributes(section, maxAttributes, i, jsonObject);
            }
            this.setUnbreakable();
        }
        catch (IOException | IllegalArgumentException | NullPointerException e) {
            FNAmplifications.getInstance().getLogger().info("An error has occurred upon initializing gear config settings! Please report on github with logs!");
            e.printStackTrace();
        }
    }

    public void initializeEnchants(String section, int i, JsonObject jsonObject) {
        try {
            String settingEnchant = "enchantment-name";
            String settingEnchantLevel = "enchantment-level";
            if (jsonObject.has("level-" + i) && jsonObject.getAsJsonObject("level-" + i).has(settingEnchant) && jsonObject.getAsJsonObject("level-" + i).has(settingEnchantLevel)) {
                this.configManager.setConfigStringValues(section, settingEnchant, jsonObject.getAsJsonObject("level-" + i).get(settingEnchant).getAsString(), "fn-gear-level-settings", false);
                this.configManager.setConfigIntegerValues(section, settingEnchantLevel, jsonObject.getAsJsonObject("level-" + i).get(settingEnchantLevel).getAsInt(), "fn-gear-level-settings", false);
            }
            if (this.configManager.getCustomConfig().isConfigurationSection(section)) {
                String enchantment = this.configManager.getCustomConfig().getConfigurationSection(section).getString(settingEnchant, "null");
                int enchantLevel = this.configManager.getCustomConfig().getConfigurationSection(section).getInt(settingEnchantLevel, 0);
                this.configManager.setMapStringValue(section, settingEnchant, enchantment);
                this.configManager.setMapIntValue(section, settingEnchantLevel, enchantLevel);
            }
        }
        catch (IOException | IllegalArgumentException | NullPointerException e) {
            FNAmplifications.getInstance().getLogger().info("An error has occurred upon initializing gear enchants setting! Please report on github with logs!");
            e.printStackTrace();
        }
    }

    public void initializeAttributes(String section, int maxAttributes, int i, JsonObject jsonObject) {
        try {
            for (int x = 1; x <= maxAttributes; ++x) {
                String attributeSection = section + ".bonus-attributes.attribute-" + x;
                String settingAttribute = "attribute-name";
                String settingAttributeValue = "attribute-value";
                if (jsonObject.has("level-" + i) && jsonObject.getAsJsonObject("level-" + i).has("attributes") && jsonObject.getAsJsonObject("level-" + i).getAsJsonObject("attributes").has("attribute-" + x)) {
                    this.configManager.setConfigStringValues(attributeSection, settingAttribute, jsonObject.getAsJsonObject("level-" + i).getAsJsonObject("attributes").get("attribute-" + x).getAsJsonObject().get(settingAttribute).getAsString(), "fn-gear-level-settings", false);
                    this.configManager.setConfigDoubleValues(attributeSection, settingAttributeValue, jsonObject.getAsJsonObject("level-" + i).getAsJsonObject("attributes").get("attribute-" + x).getAsJsonObject().get(settingAttributeValue).getAsDouble(), "fn-gear-level-settings", false);
                }
                if (!this.configManager.getCustomConfig().isConfigurationSection(attributeSection)) continue;
                String attribute = this.configManager.getCustomConfig().getConfigurationSection(attributeSection).getString(settingAttribute, "null");
                double attributeValue = this.configManager.getCustomConfig().getConfigurationSection(attributeSection).getDouble(settingAttributeValue, 0.0);
                this.configManager.setMapStringValue(attributeSection, settingAttribute, attribute);
                this.configManager.setMapDoubleValue(attributeSection, settingAttributeValue, attributeValue);
            }
        }
        catch (IOException | IllegalArgumentException | NullPointerException e) {
            FNAmplifications.getInstance().getLogger().info("An error has occurred upon initializing gear bonus attributes setting! Please report on github with logs!");
            e.printStackTrace();
        }
    }

    public final void setUnbreakable() {
        ItemMeta meta = this.getItem().getItemMeta();
        meta.setUnbreakable(this.configManager.getBoolById(this.getId(), "unbreakable"));
        this.getItem().setItemMeta(meta);
    }

    public void onHit(EntityDamageByEntityEvent event, ItemStack armour) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player p = ((Player)event.getEntity()).getPlayer();
        if (p == null) {
            return;
        }
        if (this.gearTask.onHit(event, p, armour)) {
            this.upgradeArmor(armour, this.gearTask.getLevel(), p, this.getEquipmentSlot());
        }
    }

    public void upgradeArmor(ItemStack armor, int level, Player p, EquipmentSlot slot) {
        ItemMeta meta = armor.getItemMeta();
        String section = this.getId() + ".level-" + level;
        String enchant = this.getConfigManager().getStringById(section, "enchantment-name");
        int enchantLevel = this.getConfigManager().getIntValueById(section, "enchantment-level");
        try {
            if (!enchant.equalsIgnoreCase("null") && enchantLevel != 0 && EnchantmentWrapper.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchant)) != null) {
                meta.addEnchant(EnchantmentWrapper.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchant)), enchantLevel, true);
            }
        }
        catch (IllegalArgumentException | NullPointerException e) {
            p.sendMessage(Utils.colorTranslator("&cAn error has occurred upon adding new armor enchants, please ask the admin to check the console for errors and report it on github"));
            e.printStackTrace();
        }
        if (level % 5 == 0) {
            try {
                for (int i = 1; i <= this.getMaxAttributes(); ++i) {
                    String attribute = this.getConfigManager().getStringById(section + ".bonus-attributes.attribute-" + i, "attribute-name");
                    double attributeValue = this.getConfigManager().getDoubleValueById(section + ".bonus-attributes.attribute-" + i, "attribute-value");
                    if (attribute.equalsIgnoreCase("null") || attributeValue == 0.0) continue;
                    if (meta.getAttributeModifiers(this.getEquipmentSlot()).asMap().containsKey(Attribute.valueOf((String)attribute))) {
                        meta.removeAttributeModifier(Attribute.valueOf((String)attribute));
                    }
                    meta.addAttributeModifier(Attribute.valueOf((String)attribute), new AttributeModifier(UUID.randomUUID(), "generic." + attribute.toLowerCase() + "." + armor.getType().toString().toLowerCase(), attributeValue, AttributeModifier.Operation.ADD_NUMBER, slot));
                }
                p.sendMessage(Utils.colorTranslator("&6FN Gear attributes has been increased!"));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                p.sendMessage(Utils.colorTranslator("&cAn error has occurred upon adding bonus armor attributes, please ask the admin to check the console for errors and report it on github"));
                e.printStackTrace();
            }
        }
        armor.setItemMeta(meta);
    }

    public boolean isEnchantable() {
        return true;
    }

    public boolean isDisenchantable() {
        return false;
    }

    public boolean isUseableInWorkbench() {
        return false;
    }

    public NamespacedKey getDefaultUsageKey() {
        return this.defaultUsageKey;
    }

    public NamespacedKey getDefaultUsageKey2() {
        return this.defaultUsageKey2;
    }

    public NamespacedKey getDefaultUsageKey3() {
        return this.defaultUsageKey3;
    }

    public int getStartingProgress() {
        return this.startingProgress;
    }

    public int getIncrementingProgress() {
        return this.incrementingProgress;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getMaxAttributes() {
        return this.maxAttributes;
    }

    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }

    public GearTask getGearTask() {
        return this.gearTask;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

