/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs.abstracts;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.staffs.implementations.StaffTask;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractStaff
extends SlimefunItem {
    private final NamespacedKey defaultUsageKey;
    private final StaffTask staffTask;

    public AbstractStaff(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int maxUses, NamespacedKey identifer) {
        super(itemGroup, item, recipeType, recipe);
        this.defaultUsageKey = identifer;
        this.staffTask = new StaffTask(this.getDefaultUsageKey(), this.getId());
        this.setConfigValues(maxUses, this.getItem().getType().toString());
        this.setMaterial();
        Utils.setLore(this.getItem(), this.getId(), "max-uses", "left", "&e", " left");
    }

    public void setMaterial() {
        Material matchMaterial = Material.matchMaterial((String)FNAmplifications.getInstance().getConfigManager().getStringById(this.getId(), "staff-material").toUpperCase());
        if (matchMaterial != null) {
            this.getItem().setType(matchMaterial);
        } else {
            FNAmplifications.getInstance().getLogger().log(Level.SEVERE, "Invalid Material ID for " + this.getId() + ". Will use BLAZE_ROD as default material");
        }
    }

    public boolean hasPermissionToCast(String staffName, Player player, Location location) {
        if (Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), location, Interaction.INTERACT_BLOCK)) {
            return true;
        }
        player.sendMessage(Utils.colorTranslator("&cYou don't have permission to cast " + staffName + " here!"));
        return false;
    }

    public void setConfigValues(int maxUses, String material) throws IOException {
        FNAmplifications.getInstance().getConfigManager().setConfigIntegerValues(this.getId(), "max-uses", maxUses, "staffs-settings", true);
        FNAmplifications.getInstance().getConfigManager().setConfigStringValues(this.getId(), "staff-material", material, "staffs-settings", true);
    }

    public abstract void onClick(PlayerInteractEvent var1);

    public NamespacedKey getDefaultUsageKey() {
        return this.defaultUsageKey;
    }

    public StaffTask getStaffTask() {
        return this.staffTask;
    }
}

