/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems.listener;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.events.GuardianSpawnEvent;
import ne.fnfal113.fnamplifications.gems.handlers.GemHandler;
import ne.fnfal113.fnamplifications.gems.handlers.OnBlockBreakHandler;
import ne.fnfal113.fnamplifications.gems.handlers.OnDamageHandler;
import ne.fnfal113.fnamplifications.gems.handlers.OnGuardianSpawnHandler;
import ne.fnfal113.fnamplifications.gems.handlers.OnItemDamageHandler;
import ne.fnfal113.fnamplifications.gems.handlers.OnPlayerDeathHandler;
import ne.fnfal113.fnamplifications.gems.handlers.OnProjectileDamageHandler;
import ne.fnfal113.fnamplifications.gems.handlers.OnRightClickHandler;
import ne.fnfal113.fnamplifications.gems.implementation.GemKeysEnum;
import ne.fnfal113.fnamplifications.gems.implementation.TargetReasonEnum;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Container;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class GemListener
implements Listener {
    @EventHandler
    public void onGuardianSpawn(GuardianSpawnEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        PersistentDataContainer pdc = itemStack.getItemMeta().getPersistentDataContainer();
        this.callGemHandler(OnGuardianSpawnHandler.class, handler -> handler.onGuardianSpawn(event, itemStack), itemStack, pdc, player);
    }

    public <T extends GemHandler> void callGemHandler(Class<T> clazz, Consumer<T> consumer, ItemStack itemStack, PersistentDataContainer pdc, Player p) {
        if (pdc.has(Keys.createKey(itemStack.getType().toString().toLowerCase() + "_socket_amount"), PersistentDataType.INTEGER)) {
            for (NamespacedKey key : GemKeysEnum.GEM_KEYS_ENUM.getGEM_KEYS()) {
                AbstractGem gem;
                SlimefunItem item;
                if (!pdc.has(key, PersistentDataType.STRING) || !((item = this.getSfItem(key, pdc)) instanceof AbstractGem) || !clazz.isInstance(gem = (AbstractGem)item)) continue;
                if (gem.isEnabledInCurrentWorld(gem.getId(), p.getWorld().getName())) {
                    consumer.accept((GemHandler)clazz.cast(gem));
                    continue;
                }
                p.sendMessage(Utils.colorTranslator(gem.getItemName() + "&6 is disabled in your current world!"));
            }
        }
    }

    @EventHandler
    public void onEntityDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        for (ItemStack armor : player.getInventory().getArmorContents()) {
            if (armor == null) continue;
            this.callGemHandler(OnPlayerDeathHandler.class, handler -> handler.onPlayerDeath(event, armor), armor, this.getPersistentDataContainer(armor), player);
        }
    }

    @EventHandler
    public void onDragDrop(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.getAction() != InventoryAction.SWAP_WITH_CURSOR) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Optional<SlimefunItem> slimefunItem = Optional.ofNullable(SlimefunItem.getByItem((ItemStack)event.getCursor()));
        Optional<ItemStack> currentItem = Optional.ofNullable(event.getCurrentItem());
        if (currentItem.isPresent() && slimefunItem.isPresent() && slimefunItem.get() instanceof AbstractGem) {
            ((AbstractGem)slimefunItem.get()).onDrag(event, player, slimefunItem.get(), currentItem.get());
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Player player;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (event.getDamager() instanceof Projectile && event.getCause() == EntityDamageEvent.DamageCause.PROJECTILE) {
            Projectile projectile = (Projectile)event.getDamager();
            if (!(projectile.getShooter() instanceof Player)) {
                return;
            }
            if (!(event.getEntity() instanceof LivingEntity)) {
                return;
            }
            Player player2 = (Player)projectile.getShooter();
            LivingEntity livingEntity = (LivingEntity)event.getEntity();
            if (player2.getInventory().getItemInMainHand().getType() == Material.AIR) {
                return;
            }
            ItemStack itemStackHand = player2.getInventory().getItemInMainHand();
            PersistentDataContainer pdcHand = this.getPersistentDataContainer(itemStackHand);
            this.callGemHandler(OnProjectileDamageHandler.class, handler -> handler.onProjectileDamage(event, player2, livingEntity, projectile, itemStackHand), itemStackHand, pdcHand, player2);
        }
        if (event.getDamager() instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            player = (Player)event.getDamager();
            if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
                return;
            }
            ItemStack itemStackHand = player.getInventory().getItemInMainHand();
            PersistentDataContainer pdcHand = this.getPersistentDataContainer(itemStackHand);
            this.callGemHandler(OnDamageHandler.class, handler -> handler.onDamage(event, itemStackHand), itemStackHand, pdcHand, player);
            if (event.getEntity().getPersistentDataContainer().has(Keys.GUARDIAN_KEY, PersistentDataType.STRING)) {
                if (Objects.equals(event.getEntity().getPersistentDataContainer().get(Keys.GUARDIAN_KEY, PersistentDataType.STRING), player.getName())) {
                    event.setCancelled(true);
                } else if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), event.getEntity().getLocation(), Interaction.ATTACK_ENTITY)) {
                    event.setCancelled(true);
                }
            }
        }
        if (event.getEntity() instanceof Player) {
            player = (Player)event.getEntity();
            for (ItemStack armor : player.getInventory().getArmorContents()) {
                if (armor == null) continue;
                this.callGemHandler(OnDamageHandler.class, handler -> handler.onDamage(event, armor), armor, this.getPersistentDataContainer(armor), player);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (event.getBlock().getState() instanceof Container) {
            return;
        }
        if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        PersistentDataContainer pdc = this.getPersistentDataContainer(itemStack);
        this.callGemHandler(OnBlockBreakHandler.class, handler -> handler.onBlockBreak(event, player), itemStack, pdc, player);
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        PersistentDataContainer pdc = this.getPersistentDataContainer(itemStack);
        this.callGemHandler(OnRightClickHandler.class, handler -> handler.onRightClick(player), itemStack, pdc, player);
    }

    @EventHandler
    public void onItemDamage(PlayerItemDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        PersistentDataContainer pdc = this.getPersistentDataContainer(event.getItem());
        this.callGemHandler(OnItemDamageHandler.class, handler -> handler.onDurabilityChange(event), event.getItem(), pdc, event.getPlayer());
    }

    @EventHandler
    public void onMobTarget(EntityTargetLivingEntityEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getEntity() instanceof Zombie) {
            Zombie zombieTarget;
            Zombie zombie = (Zombie)event.getEntity();
            if (event.getTarget() instanceof Player) {
                Player player = (Player)event.getTarget();
                if (!zombie.getPersistentDataContainer().has(Keys.GUARDIAN_KEY, PersistentDataType.STRING)) {
                    return;
                }
                if (Objects.equals(zombie.getPersistentDataContainer().get(Keys.GUARDIAN_KEY, PersistentDataType.STRING), player.getName())) {
                    event.setCancelled(true);
                }
                if (TargetReasonEnum.PLAYER_TARGET.isTagged(event.getReason())) {
                    event.setTarget(null);
                    event.setCancelled(true);
                }
            }
            if (event.getTarget() instanceof Zombie && (zombieTarget = (Zombie)event.getTarget()).getPersistentDataContainer().has(Keys.GUARDIAN_KEY, PersistentDataType.STRING) && TargetReasonEnum.ZOMBIE_TARGET.isTagged(event.getReason())) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void entityBlockChange(EntityChangeBlockEvent event) {
        if (event.getEntity().getType() == EntityType.FALLING_BLOCK && event.getEntity().hasMetadata("shockwave_gem")) {
            event.setCancelled(true);
            event.getEntity().removeMetadata("shockwave_gem", (Plugin)FNAmplifications.getInstance());
            event.getEntity().remove();
        }
    }

    @Nullable
    public SlimefunItem getSfItem(NamespacedKey key, PersistentDataContainer pdc) {
        return SlimefunItem.getById((String)Objects.requireNonNull((String)pdc.get(key, PersistentDataType.STRING)));
    }

    public PersistentDataContainer getPersistentDataContainer(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        Validate.notNull((Object)meta, (String)("Meta must not be null! Item type (for debugging): " + itemStack.getType()));
        return meta.getPersistentDataContainer();
    }
}

