/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.handlers.OnRightClickHandler;
import ne.fnfal113.fnamplifications.gems.implementation.Gem;
import ne.fnfal113.fnamplifications.gems.implementation.ThrowableWeapon;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class DamnationGem
extends AbstractGem
implements OnRightClickHandler {
    private final ThrowableWeapon throwableWeapon = new ThrowableWeapon();

    public DamnationGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    public void onDrag(InventoryClickEvent event, Player player, SlimefunItem slimefunItem, ItemStack currentItem) {
        if (WeaponArmorEnum.SWORDS.isTagged(currentItem.getType()) || WeaponArmorEnum.AXES.isTagged(currentItem.getType())) {
            new Gem(slimefunItem, currentItem, player).onDrag(event, false);
        } else {
            player.sendMessage(Utils.colorTranslator("&eInvalid item to socket! Gem works on axes and swords only"));
        }
    }

    @Override
    public void onRightClick(Player player) {
        if (!player.isSneaking()) {
            return;
        }
        if (!this.hasPermissionToThrow(player)) {
            player.sendMessage(Utils.colorTranslator("&eYou don't have the permission to use damnation here! (Needs block interaction flag enabled)"));
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemMeta meta = itemStack.getItemMeta();
        if (this.throwableWeapon.isBelow4Weapons(player)) {
            PersistentDataContainer pdc = itemStack.getItemMeta().getPersistentDataContainer();
            try {
                String pdcValue = (String)pdc.getOrDefault(Keys.RETURN_WEAPON_KEY, PersistentDataType.STRING, (Object)"false");
                this.throwableWeapon.floatThrowItem(player, itemStack.clone(), pdcValue.equalsIgnoreCase("true"));
            }
            catch (IllegalArgumentException e) {
                pdc.set(Keys.RETURN_WEAPON_KEY, PersistentDataType.STRING, (Object)"true");
                itemStack.setItemMeta(meta);
                return;
            }
            itemStack.setAmount(0);
        }
    }
}

