/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.powergenerators.implementation;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.core.attributes.HologramOwner;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import ne.fnfal113.fnamplifications.ExtraUtils.utils.LoreBuilderDynamic;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class CustomPowerGen
extends SlimefunItem
implements HologramOwner,
EnergyNetProvider {
    private final Map<Location, Boolean> HOLO_CACHE = new HashMap<Location, Boolean>();

    public CustomPowerGen(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int dayRate, int nightRate, int output, int storage) {
        super(itemGroup, item, recipeType, recipe);
        this.setConfigValues(dayRate, nightRate, output, storage);
        this.setLore(this.getItem());
        this.addItemHandler(new ItemHandler[]{this.toggleHologram(), new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                if (BlockStorage.getLocationInfo((Location)e.getBlock().getLocation(), (String)"holo_status").startsWith("true")) {
                    CustomPowerGen.this.removeHologram(e.getBlock());
                }
            }
        }, new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"holo_status", (String)"true");
                CustomPowerGen.this.HOLO_CACHE.put(e.getBlock().getLocation(), true);
                CustomPowerGen.this.toggleHologram();
            }
        }});
    }

    public void setLore(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        List lore = meta.getLore();
        lore.add(Utils.colorTranslator(LoreBuilderDynamic.powerBuffer(FNAmplifications.getInstance().getConfigManager().getValueById(this.getId(), "storage"))));
        lore.add(Utils.colorTranslator(LoreBuilderDynamic.powerPerTick(FNAmplifications.getInstance().getConfigManager().getValueById(this.getId(), "dayrate")) + " (Day Rate)"));
        lore.add(Utils.colorTranslator(LoreBuilderDynamic.powerPerTick(FNAmplifications.getInstance().getConfigManager().getValueById(this.getId(), "nightrate")) + " (Night Rate)"));
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
    }

    public void setConfigValues(int dayRate, int nightRate, int output, int storage) throws IOException {
        FNAmplifications.getInstance().getConfigManager().setConfigIntegerValues(this.getId(), "dayrate", dayRate, "power-xpansion-settings", true);
        FNAmplifications.getInstance().getConfigManager().setConfigIntegerValues(this.getId(), "nightrate", nightRate, "power-xpansion-settings", true);
        FNAmplifications.getInstance().getConfigManager().setConfigIntegerValues(this.getId(), "output", output, "power-xpansion-settings", true);
        FNAmplifications.getInstance().getConfigManager().setConfigIntegerValues(this.getId(), "storage", storage, "power-xpansion-settings", true);
    }

    @Nonnull
    public Vector getHologramOffset(@Nonnull Block b) {
        return new Vector(0.5, 0.7, 0.5);
    }

    public BlockUseHandler toggleHologram() {
        return e -> {
            if (!e.getClickedBlock().isPresent()) {
                return;
            }
            Block block = (Block)e.getClickedBlock().get();
            String holoStatus = BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"holo_status");
            if (holoStatus == null) {
                BlockStorage.addBlockInfo((Location)block.getLocation(), (String)"holo_status", (String)"true");
                this.HOLO_CACHE.put(block.getLocation(), true);
                this.toggleHologram();
            } else if (this.HOLO_CACHE.get(block.getLocation()).booleanValue()) {
                this.HOLO_CACHE.put(block.getLocation(), false);
                BlockStorage.addBlockInfo((Location)block.getLocation(), (String)"holo_status", (String)"false");
                this.removeHologram(block);
            } else {
                this.HOLO_CACHE.put(block.getLocation(), true);
                BlockStorage.addBlockInfo((Location)block.getLocation(), (String)"holo_status", (String)"true");
                this.toggleHologram();
            }
        };
    }

    public int getGeneratedOutput(@Nonnull Location l, @Nonnull Config data) {
        int stored = this.getCharge(l);
        Validate.notNull((Object)l.getWorld());
        if (!this.HOLO_CACHE.containsKey(l)) {
            if (BlockStorage.getLocationInfo((Location)l, (String)"holo_status") != null) {
                this.HOLO_CACHE.put(l, Boolean.parseBoolean(BlockStorage.getLocationInfo((Location)l, (String)"holo_status")));
            } else {
                BlockStorage.addBlockInfo((Location)l, (String)"holo_status", (String)"true");
                this.HOLO_CACHE.put(l, true);
            }
        } else if (this.HOLO_CACHE.get(l).booleanValue()) {
            String charge = this.getCharge(l) <= 0 ? Utils.colorTranslator("&8" + this.getCharge(l)) : Utils.colorTranslator("&a" + this.getCharge(l));
            this.updateHologram(l.getBlock(), Utils.colorTranslator("&eStored &a\u26a1: " + charge));
        }
        return stored < this.getCapacity() ? this.getGeneratingAmount(l.getBlock(), l.getWorld()) : 0;
    }

    public boolean willExplode(@Nonnull Location l, @Nonnull Config data) {
        return false;
    }

    private int getGeneratingAmount(@Nonnull Block loc, @Nonnull World world) {
        if (world.getEnvironment() == World.Environment.NETHER) {
            return this.getDayRate();
        }
        if (world.getEnvironment() == World.Environment.THE_END) {
            return this.getNightRate();
        }
        if (world.isThundering() || world.hasStorm() || world.getTime() >= 13000L || loc.getLocation().add(0.0, 1.0, 0.0).getBlock().getLightFromSky() != 15) {
            return this.getNightRate();
        }
        return this.getDayRate();
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.GENERATOR;
    }

    public int getCapacity() {
        return FNAmplifications.getInstance().getConfigManager().getValueById(this.getId(), "storage");
    }

    public int getDayRate() {
        return FNAmplifications.getInstance().getConfigManager().getValueById(this.getId(), "dayrate");
    }

    public int getNightRate() {
        return FNAmplifications.getInstance().getConfigManager().getValueById(this.getId(), "nightrate");
    }
}

