/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.quivers.implementations;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import ne.fnfal113.fnamplifications.quivers.abstracts.AbstractQuiver;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class QuiverTask {
    private final NamespacedKey storageKey;
    private final NamespacedKey storageKey2;
    private final NamespacedKey storageKey3;
    private final int quiverSize;
    private final ItemStack arrowType;
    private final SlimefunItemStack sfItemStack;

    public QuiverTask(NamespacedKey key1, NamespacedKey key2, NamespacedKey key3, int quiverSize, ItemStack arrow, SlimefunItemStack slimefunItemStack) {
        this.storageKey = key1;
        this.storageKey2 = key2;
        this.storageKey3 = key3;
        this.quiverSize = quiverSize;
        this.arrowType = arrow;
        this.sfItemStack = slimefunItemStack;
    }

    @Nullable
    public SlimefunItem getSfItem(ItemStack itemStack) {
        return SlimefunItem.getByItem((ItemStack)itemStack);
    }

    public int getArrows(PersistentDataContainer arrowPdc, NamespacedKey key) {
        return (Integer)arrowPdc.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
    }

    public boolean isQuiver(@Nullable SlimefunItem item) {
        return item instanceof AbstractQuiver;
    }

    public void changeState(ItemStack itemState, ItemMeta meta, PersistentDataContainer arrowsCheck) {
        boolean pdcCheck;
        int arrowsCheckPDC = this.getArrows(arrowsCheck, this.getStorageKey());
        boolean bl = pdcCheck = arrowsCheckPDC == 0;
        if (pdcCheck) {
            return;
        }
        if (itemState.getType() == Material.LEATHER) {
            meta.getPersistentDataContainer().set(this.getStorageKey3(), PersistentDataType.STRING, (Object)"opened");
            itemState.setType(this.getArrowType().getType());
            Utils.updateValueByPdc(itemState, meta, "Opened", "State: ", "&e", "&f", " quiver");
        } else {
            meta.getPersistentDataContainer().set(this.getStorageKey3(), PersistentDataType.STRING, (Object)"closed");
            itemState.setType(Material.LEATHER);
            Utils.updateValueByPdc(itemState, meta, "Closed", "State: ", "&e", "&f", " quiver");
        }
    }

    public void withdrawArrows(ItemStack itemState, ItemMeta meta, Player player, PersistentDataContainer arrowsCheck) {
        boolean pdcCheck;
        int arrowsCheckPDC = this.getArrows(arrowsCheck, this.getStorageKey());
        boolean bl = pdcCheck = arrowsCheckPDC == 0;
        if (pdcCheck) {
            return;
        }
        int amount = arrowsCheckPDC - 1;
        meta.getPersistentDataContainer().set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)amount);
        if (amount == 0) {
            if (meta.getPersistentDataContainer().has(this.getStorageKey3(), PersistentDataType.STRING)) {
                meta.getPersistentDataContainer().remove(this.getStorageKey3());
            }
            itemState.setType(Material.LEATHER);
            player.sendMessage(ChatColor.GOLD + this.getSfItemStack().getDisplayName() + " is now empty");
            Utils.updateValueByPdc(itemState, meta, "Closed (No arrows)", "State: ", "&e", "&f", "");
        }
        Utils.updateValueByPdc(itemState, meta, String.valueOf(amount), "Arrows: ", "&e", "&f", " left");
        player.getInventory().addItem(new ItemStack[]{this.getArrowType().clone()});
    }

    public void depositArrows(ItemStack item, ItemMeta meta, PersistentDataContainer arrowsCheck, Player player) {
        ItemStack arrow = player.getInventory().getItemInMainHand();
        int arrowsCheckPDC = this.getArrows(arrowsCheck, this.getStorageKey());
        if (arrow.getType() != this.getArrowType().getType()) {
            return;
        }
        if (this.isQuiver(this.getSfItem(arrow))) {
            return;
        }
        if (item.getAmount() != 1) {
            player.sendMessage(Utils.colorTranslator("&eUnstack the quivers first before using them"));
            return;
        }
        int increment = arrowsCheckPDC + 1;
        if (increment != this.getQuiverSize() + 1) {
            meta.getPersistentDataContainer().set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)increment);
            if (increment <= 2) {
                int random = ThreadLocalRandom.current().nextInt(1, 1000000);
                meta.getPersistentDataContainer().set(this.getStorageKey2(), PersistentDataType.INTEGER, (Object)random);
            }
            item.setType(this.getArrowType().getType());
            arrow.setAmount(arrow.getAmount() - 1);
            Utils.updateValueByPdc(item, meta, String.valueOf(increment), "Arrows: ", "&e", "&f", " left");
            Utils.updateValueByPdc(item, meta, "Opened", "State: ", "&e", "&f", " quiver");
            if (increment == this.getQuiverSize()) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.getSfItemStack().getDisplayName() + " is full!")));
            }
        }
    }

    public void bowShoot(EntityShootBowEvent event, ItemStack itemStack, boolean checkInfinity) {
        if (itemStack == null) {
            return;
        }
        Player player = (Player)event.getEntity();
        event.setCancelled(true);
        float bowForce = event.getForce();
        if (itemStack.getType() == Material.ARROW) {
            Arrow arrow = (Arrow)player.launchProjectile(Arrow.class);
            arrow.setVelocity(arrow.getVelocity().multiply(bowForce));
        }
        if (itemStack.getType() == Material.SPECTRAL_ARROW) {
            SpectralArrow spectralArrow = (SpectralArrow)player.launchProjectile(SpectralArrow.class);
            spectralArrow.setVelocity(spectralArrow.getVelocity().multiply(bowForce));
        }
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ARROW_SHOOT, 1.0f, 1.0f);
        player.updateInventory();
        ItemMeta meta = itemStack.getItemMeta();
        ItemMeta bowMeta = player.getInventory().getItemInMainHand().getItemMeta();
        if (meta == null || bowMeta == null) {
            return;
        }
        PersistentDataContainer arrow_Left = meta.getPersistentDataContainer();
        int arrows = this.getArrows(arrow_Left, this.getStorageKey());
        int decrement = arrows - 1;
        if (checkInfinity && bowMeta.hasEnchant(Enchantment.ARROW_INFINITE)) {
            decrement = arrows;
        }
        if (decrement >= 0) {
            arrow_Left.set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)decrement);
            if (decrement == 0) {
                if (arrow_Left.has(this.getStorageKey3(), PersistentDataType.STRING)) {
                    meta.getPersistentDataContainer().remove(this.getStorageKey3());
                }
                itemStack.setType(Material.LEATHER);
                Utils.updateValueByPdc(itemStack, meta, "Closed (No arrows)", "State: ", "&e", "&f", "");
            }
            Utils.updateValueByPdc(itemStack, meta, String.valueOf(decrement), "Arrows: ", "&e", "&f", " left");
        }
    }

    public NamespacedKey getStorageKey() {
        return this.storageKey;
    }

    public NamespacedKey getStorageKey2() {
        return this.storageKey2;
    }

    public NamespacedKey getStorageKey3() {
        return this.storageKey3;
    }

    public int getQuiverSize() {
        return this.quiverSize;
    }

    public ItemStack getArrowType() {
        return this.arrowType;
    }

    public SlimefunItemStack getSfItemStack() {
        return this.sfItemStack;
    }
}

