/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.machines.abstracts;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.operations.CraftingOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class CMachine
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent,
MachineProcessHolder<CraftingOperation> {
    public final List<MachineRecipe> recipes = new ArrayList<MachineRecipe>();
    public final MachineProcessor<CraftingOperation> processor = new MachineProcessor((MachineProcessHolder)this);
    private int energyConsumedPerTick = -1;
    private int energyCapacity = -1;
    private int processingSpeed = -1;

    @ParametersAreNonnullByDefault
    protected CMachine(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.processor.setProgressBar(this.getProgressBar());
        this.createPreset(this, this.getInventoryTitle(), this::constructMenu);
        this.addItemHandler(new ItemHandler[]{this.onBlockBreak()});
    }

    @Nonnull
    protected BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), CMachine.this.getInputSlots());
                    inv.dropItems(b.getLocation(), CMachine.this.getOutputSlots());
                }
                CMachine.this.processor.endOperation(b);
            }
        };
    }

    @ParametersAreNonnullByDefault
    protected CMachine(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        this(itemGroup, item, recipeType, recipe);
        this.recipeOutput = recipeOutput;
    }

    public MachineProcessor<CraftingOperation> getMachineProcessor() {
        return this.processor;
    }

    public int[] getBorder() {
        return new int[]{0, 2, 4, 8, 9, 13, 17, 18, 26, 27, 31, 35, 36, 38, 40, 44};
    }

    public int[] getInputBorder() {
        return new int[]{1, 3, 10, 11, 12, 19, 21, 28, 29, 30, 37, 39};
    }

    public int[] getOutputBorder() {
        return new int[]{5, 6, 7, 14, 16, 23, 24, 25, 32, 34, 41, 42, 43};
    }

    public int getProgressBarSlot() {
        return 22;
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : this.getBorder()) {
            preset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getInputBorder()) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.PINK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getOutputBorder()) {
            preset.addItem(i, (ItemStack)new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(this.getProgressBarSlot(), (ItemStack)new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
    }

    @Nonnull
    public String getInventoryTitle() {
        return this.getItemName();
    }

    public abstract ItemStack getProgressBar();

    public int getCapacity() {
        return this.energyCapacity;
    }

    public int getEnergyConsumption() {
        return this.energyConsumedPerTick;
    }

    public int getSpeed() {
        return this.processingSpeed;
    }

    public final CMachine setCapacity(int capacity) {
        Validate.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"The capacity must be greater than zero!");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    public final CMachine setProcessingSpeed(int speed) {
        Validate.isTrue((speed > 0 ? 1 : 0) != 0, (String)"The speed must be greater than zero!");
        this.processingSpeed = speed;
        return this;
    }

    public final CMachine setEnergyConsumption(int energyConsumption) {
        Validate.isTrue((energyConsumption > 0 ? 1 : 0) != 0, (String)"The energy consumption must be greater than zero!");
        Validate.isTrue((this.energyCapacity > 0 ? 1 : 0) != 0, (String)"You must specify the capacity before you can set the consumption amount.");
        Validate.isTrue((energyConsumption <= this.energyCapacity ? 1 : 0) != 0, (String)("The energy consumption cannot be higher than the capacity (" + this.energyCapacity + ')'));
        this.energyConsumedPerTick = energyConsumption;
        return this;
    }

    public void register(@Nonnull SlimefunAddon addon) {
        this.addon = addon;
        if (this.getCapacity() <= 0) {
            this.warn("The capacity has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + ((Object)((Object)this)).getClass().getSimpleName() + "#setEnergyCapacity(...)' before registering!");
        }
        if (this.getEnergyConsumption() <= 0) {
            this.warn("The energy consumption has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + ((Object)((Object)this)).getClass().getSimpleName() + "#setEnergyConsumption(...)' before registering!");
        }
        if (this.getSpeed() <= 0) {
            this.warn("The processing speed has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + ((Object)((Object)this)).getClass().getSimpleName() + "#setProcessingSpeed(...)' before registering!");
        }
        this.registerDefaultRecipes();
        if (this.getCapacity() > 0 && this.getEnergyConsumption() > 0 && this.getSpeed() > 0) {
            super.register(addon);
        }
    }

    @Nonnull
    public abstract String getMachineIdentifier();

    protected void registerDefaultRecipes() {
    }

    public List<MachineRecipe> getMachineRecipes() {
        return this.recipes;
    }

    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>(this.recipes.size() * 2);
        for (MachineRecipe recipe : this.recipes) {
            if (recipe.getInput().length != 1) continue;
            displayRecipes.add(recipe.getInput()[0]);
            displayRecipes.add(recipe.getOutput()[0]);
        }
        return displayRecipes;
    }

    public int[] getInputSlots() {
        return new int[]{20};
    }

    public int[] getOutputSlots() {
        return new int[]{15, 33};
    }

    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public void registerRecipe(MachineRecipe recipe) {
        recipe.setTicks(recipe.getTicks() / this.getSpeed());
        this.recipes.add(recipe);
    }

    public void registerRecipe(int seconds, ItemStack[] input, ItemStack[] output) {
        this.registerRecipe(new MachineRecipe(seconds, input, output));
    }

    public void registerRecipe(int seconds, ItemStack input, ItemStack output) {
        this.registerRecipe(new MachineRecipe(seconds, new ItemStack[]{input}, new ItemStack[]{output}));
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                CMachine.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    public void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        CraftingOperation currentOperation = (CraftingOperation)this.processor.getOperation(b);
        if (currentOperation != null) {
            if (this.takeCharge(b.getLocation())) {
                if (!currentOperation.isFinished()) {
                    this.processor.updateProgressBar(inv, 22, (MachineOperation)currentOperation);
                    currentOperation.addProgress(1);
                } else {
                    inv.replaceExistingItem(22, (ItemStack)new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
                    for (ItemStack output : currentOperation.getResults()) {
                        inv.pushItem(output.clone(), this.getOutputSlots());
                    }
                    this.processor.endOperation(b);
                }
            }
        } else {
            MachineRecipe next = this.findNextRecipe(inv);
            if (next != null) {
                this.processor.startOperation(b, (MachineOperation)new CraftingOperation(next));
            }
        }
    }

    protected boolean takeCharge(@Nonnull Location l) {
        Validate.notNull((Object)l, (String)"Can't attempt to take charge from a null location!");
        if (this.isChargeable()) {
            int charge = this.getCharge(l);
            if (charge < this.getEnergyConsumption()) {
                return false;
            }
            this.setCharge(l, charge - this.getEnergyConsumption());
            return true;
        }
        return true;
    }

    protected MachineRecipe findNextRecipe(BlockMenu inv) {
        HashMap<Integer, ItemStackWrapper> inventory = new HashMap<Integer, ItemStackWrapper>();
        for (int slot : this.getInputSlots()) {
            ItemStack itemStack = inv.getItemInSlot(slot);
            if (itemStack == null) continue;
            inventory.put(slot, ItemStackWrapper.wrap((ItemStack)itemStack));
        }
        HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
        for (MachineRecipe recipe : this.recipes) {
            block2: for (ItemStack input : recipe.getInput()) {
                for (int slot : this.getInputSlots()) {
                    if (!SlimefunUtils.isItemSimilar((ItemStack)((ItemStack)inventory.get(slot)), (ItemStack)input, (boolean)true)) continue;
                    found.put(slot, input.getAmount());
                    continue block2;
                }
            }
            if (found.size() == recipe.getInput().length) {
                if (!InvUtils.fitAll((Inventory)inv.toInventory(), (ItemStack[])recipe.getOutput(), (int[])this.getOutputSlots())) {
                    return null;
                }
                for (Map.Entry entry : found.entrySet()) {
                    inv.consumeItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue());
                }
                return recipe;
            }
            found.clear();
        }
        return null;
    }
}

