/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gears;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import ne.fnfal113.fnamplifications.gears.abstracts.AbstractGears;
import ne.fnfal113.fnamplifications.gears.implementation.MainGears;
import ne.fnfal113.fnamplifications.utils.Keys;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class FnChestPlate
extends AbstractGears {
    private final NamespacedKey defaultUsageKey = Keys.FN_GEAR_CHEST;
    private final NamespacedKey defaultUsageKey2 = Keys.FN_GEAR_CHEST_LEVEL;
    private final NamespacedKey defaultUsageKey3 = Keys.FN_GEAR_CHEST_FINAL;
    private final MainGears mainGears;

    @ParametersAreNonnullByDefault
    public FnChestPlate(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.mainGears = new MainGears(this.getStorageKey(), this.getStorageKey2(), this.getStorageKey3(), (ItemStack)item, 30, 120);
    }

    @Nonnull
    protected NamespacedKey getStorageKey() {
        return this.defaultUsageKey;
    }

    @Nonnull
    protected NamespacedKey getStorageKey2() {
        return this.defaultUsageKey2;
    }

    @Nonnull
    protected NamespacedKey getStorageKey3() {
        return this.defaultUsageKey3;
    }

    @Override
    public void onHit(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player p = ((Player)event.getEntity()).getPlayer();
        if (p == null) {
            return;
        }
        ItemStack itemStack = p.getInventory().getChestplate();
        if (this.mainGears.onHit(event, p, itemStack)) {
            this.upgradeArmor(itemStack, this.mainGears.getLevel(), p);
        }
    }

    @Override
    public void upgradeArmor(ItemStack armor, int level, Player p) {
        ItemMeta meta = armor.getItemMeta();
        if (level == 1) {
            meta.addEnchant(Enchantment.PROTECTION_PROJECTILE, 3, true);
            armor.setItemMeta(meta);
        } else if (level == 2) {
            meta.addEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 3, true);
            armor.setItemMeta(meta);
        } else if (level == 3) {
            meta.addEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 6, true);
            armor.setItemMeta(meta);
        } else if (level == 4) {
            meta.addEnchant(Enchantment.PROTECTION_PROJECTILE, 6, true);
            armor.setItemMeta(meta);
        } else if (level == 5) {
            meta.addEnchant(Enchantment.PROTECTION_EXPLOSIONS, 3, true);
            meta.removeAttributeModifier(EquipmentSlot.CHEST);
            armor.setItemMeta(meta);
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR, new AttributeModifier(UUID.randomUUID(), "generic.armorBonus.chest", 10.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR_TOUGHNESS, new AttributeModifier(UUID.randomUUID(), "generic.armorTough.chest", 3.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            meta.addAttributeModifier(Attribute.GENERIC_KNOCKBACK_RESISTANCE, new AttributeModifier(UUID.randomUUID(), "generic.knockbackResistance.chest", 0.1, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            armor.setItemMeta(meta);
            p.sendMessage(ChatColor.GOLD + "Chestplate attributes has been increased!");
        } else if (level == 6) {
            meta.addEnchant(Enchantment.PROTECTION_EXPLOSIONS, 6, true);
            armor.setItemMeta(meta);
        } else if (level == 7) {
            meta.addEnchant(Enchantment.PROTECTION_FIRE, 3, true);
            armor.setItemMeta(meta);
        } else if (level == 8) {
            meta.addEnchant(Enchantment.PROTECTION_FIRE, 6, true);
            armor.setItemMeta(meta);
        } else if (level == 9) {
            meta.addEnchant(Enchantment.PROTECTION_FIRE, 10, true);
            armor.setItemMeta(meta);
        } else if (level == 10) {
            meta.addEnchant(Enchantment.THORNS, 3, true);
            meta.removeAttributeModifier(EquipmentSlot.CHEST);
            armor.setItemMeta(meta);
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR, new AttributeModifier(UUID.randomUUID(), "generic.armorBonus.chest", 10.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR_TOUGHNESS, new AttributeModifier(UUID.randomUUID(), "generic.armorTough.chest", 5.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            meta.addAttributeModifier(Attribute.GENERIC_KNOCKBACK_RESISTANCE, new AttributeModifier(UUID.randomUUID(), "generic.knockbackResistance.chest", 0.1, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            armor.setItemMeta(meta);
            p.sendMessage(ChatColor.GOLD + "Chestplate attributes has been increased!");
        } else if (level == 11) {
            meta.addEnchant(Enchantment.THORNS, 6, true);
            armor.setItemMeta(meta);
        } else if (level == 12) {
            meta.addEnchant(Enchantment.PROTECTION_PROJECTILE, 10, true);
            armor.setItemMeta(meta);
        } else if (level == 13) {
            meta.addEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 10, true);
            armor.setItemMeta(meta);
        } else if (level == 14) {
            meta.addEnchant(Enchantment.PROTECTION_EXPLOSIONS, 10, true);
            armor.setItemMeta(meta);
        } else if (level == 15) {
            meta.addEnchant(Enchantment.THORNS, 10, true);
            meta.removeAttributeModifier(EquipmentSlot.CHEST);
            armor.setItemMeta(meta);
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR, new AttributeModifier(UUID.randomUUID(), "generic.armorBonus.chest", 10.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR_TOUGHNESS, new AttributeModifier(UUID.randomUUID(), "generic.armorTough.chest", 5.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            meta.addAttributeModifier(Attribute.GENERIC_KNOCKBACK_RESISTANCE, new AttributeModifier(UUID.randomUUID(), "generic.knockbackResistance.chest", 0.3, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            armor.setItemMeta(meta);
            p.sendMessage(ChatColor.GOLD + "Chestplate attributes has been increased!");
        } else if (level == 16) {
            meta.addEnchant(Enchantment.PROTECTION_PROJECTILE, 15, true);
            armor.setItemMeta(meta);
        } else if (level == 17) {
            meta.addEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 14, true);
            armor.setItemMeta(meta);
        } else if (level == 18) {
            meta.addEnchant(Enchantment.PROTECTION_EXPLOSIONS, 16, true);
            armor.setItemMeta(meta);
        } else if (level == 19) {
            meta.addEnchant(Enchantment.THORNS, 15, true);
            armor.setItemMeta(meta);
        } else if (level == 20) {
            meta.addEnchant(Enchantment.PROTECTION_FIRE, 15, true);
            meta.removeAttributeModifier(EquipmentSlot.CHEST);
            armor.setItemMeta(meta);
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR, new AttributeModifier(UUID.randomUUID(), "generic.armorBonus.chest", 10.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR_TOUGHNESS, new AttributeModifier(UUID.randomUUID(), "generic.armorTough.chest", 5.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            meta.addAttributeModifier(Attribute.GENERIC_KNOCKBACK_RESISTANCE, new AttributeModifier(UUID.randomUUID(), "generic.knockbackResistance.chest", 0.4, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            armor.setItemMeta(meta);
            p.sendMessage(ChatColor.GOLD + "Chestplate attributes has been increased!");
        } else if (level == 21) {
            meta.addEnchant(Enchantment.PROTECTION_PROJECTILE, 20, true);
            armor.setItemMeta(meta);
        } else if (level == 22) {
            meta.addEnchant(Enchantment.PROTECTION_ENVIRONMENTAL, 20, true);
            armor.setItemMeta(meta);
        } else if (level == 23) {
            meta.addEnchant(Enchantment.PROTECTION_EXPLOSIONS, 20, true);
            armor.setItemMeta(meta);
        } else if (level == 24) {
            meta.addEnchant(Enchantment.THORNS, 20, true);
            armor.setItemMeta(meta);
        } else if (level == 25) {
            meta.addEnchant(Enchantment.PROTECTION_FIRE, 20, true);
            meta.removeAttributeModifier(EquipmentSlot.CHEST);
            armor.setItemMeta(meta);
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR, new AttributeModifier(UUID.randomUUID(), "generic.armorBonus.chest", 12.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR_TOUGHNESS, new AttributeModifier(UUID.randomUUID(), "generic.armorTough.chest", 5.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            meta.addAttributeModifier(Attribute.GENERIC_KNOCKBACK_RESISTANCE, new AttributeModifier(UUID.randomUUID(), "generic.knockbackResistance.chest", 0.4, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.CHEST));
            armor.setItemMeta(meta);
            p.sendMessage(ChatColor.GOLD + "Chestplate attributes has been increased!");
        }
    }

    public boolean isEnchantable() {
        return true;
    }

    public boolean isDisenchantable() {
        return false;
    }

    public boolean isUseableInWorkbench() {
        return false;
    }
}

