/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ne.fnfal113.fnamplifications.FNAmplifications;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private File customConfigFile;
    private FileConfiguration customConfig;
    private final Map<String, Integer> integerValues = new HashMap<String, Integer>();
    private final Map<String, Boolean> booleanValues = new HashMap<String, Boolean>();

    public void setBooleanValues(String itemNameSection, String settings, boolean bool, String fileName) throws IOException {
        if (this.createCustomConfig(fileName)) {
            if (!this.getCustomConfig().isConfigurationSection(itemNameSection)) {
                this.getCustomConfig().createSection(itemNameSection).set(settings, (Object)bool);
            } else if (this.getCustomConfig().isConfigurationSection(itemNameSection) && !this.getCustomConfig().getConfigurationSection(itemNameSection).getKeys(false).contains(settings)) {
                this.getCustomConfig().getConfigurationSection(itemNameSection).set(settings, (Object)bool);
            }
            this.getCustomConfig().save(this.customConfigFile);
            boolean value = this.getCustomConfig().getConfigurationSection(itemNameSection).getBoolean(settings, false);
            this.booleanValues.put(itemNameSection + "." + settings, value);
        }
    }

    public void setIntegerValues(String itemNameSection, String settings, Integer val, String fileName) throws IOException {
        if (this.createCustomConfig(fileName)) {
            if (!this.getCustomConfig().isConfigurationSection(itemNameSection)) {
                this.getCustomConfig().createSection(itemNameSection).set(settings, (Object)val);
            } else if (this.getCustomConfig().isConfigurationSection(itemNameSection) && !this.getCustomConfig().getConfigurationSection(itemNameSection).getKeys(false).contains(settings)) {
                this.getCustomConfig().getConfigurationSection(itemNameSection).set(settings, (Object)val);
            }
            this.getCustomConfig().save(this.customConfigFile);
            int value = this.getCustomConfig().getConfigurationSection(itemNameSection).getInt(settings, 0);
            this.integerValues.put(itemNameSection + "." + settings, value);
        }
    }

    private boolean createCustomConfig(String fileName) {
        this.customConfigFile = new File(FNAmplifications.getInstance().getDataFolder(), fileName + ".yml");
        if (!this.customConfigFile.exists()) {
            this.customConfigFile.getParentFile().mkdirs();
            FNAmplifications.getInstance().saveResource(fileName + ".yml", false);
        }
        this.customConfig = new YamlConfiguration();
        try {
            this.customConfig.load(this.customConfigFile);
            return true;
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            return false;
        }
    }

    public FileConfiguration getCustomConfig() {
        return this.customConfig;
    }

    public int getValueById(String itemSection, String setting) {
        return this.getIntegerValues().get(itemSection + "." + setting);
    }

    public boolean getBoolById(String itemSection, String setting) {
        return this.getBooleanValues().get(itemSection + "." + setting);
    }

    public Map<String, Integer> getIntegerValues() {
        return this.integerValues;
    }

    public Map<String, Boolean> getBooleanValues() {
        return this.booleanValues;
    }
}

