/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.quivers.abstracts;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import ne.fnfal113.fnamplifications.quivers.implementations.MainQuiver;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractQuiver
extends SlimefunItem {
    private final NamespacedKey storageKey;
    private final NamespacedKey storageKey2;
    private final NamespacedKey storageKey3;
    private final MainQuiver mainQuiver;
    private final int quiverSize;
    private final ItemStack arrowType;

    public AbstractQuiver(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, NamespacedKey arrowKey, NamespacedKey arrowIDKey, NamespacedKey quiverStateKey, int quiverSize, ItemStack arrowType) {
        super(itemGroup, item, recipeType, recipe);
        this.storageKey = arrowKey;
        this.storageKey2 = arrowIDKey;
        this.storageKey3 = quiverStateKey;
        this.quiverSize = quiverSize;
        this.arrowType = arrowType;
        this.mainQuiver = new MainQuiver(arrowKey, arrowIDKey, quiverStateKey, this.getQuiverSize(), this.getArrowType(), item);
    }

    public void onArrowDeposit(Player player, ItemStack item) {
        this.getMainQuiver().depositArrows(item, item.getItemMeta(), item.getItemMeta().getPersistentDataContainer(), player);
    }

    public void onArrowWithdraw(PlayerInteractEvent event, ItemStack item) {
        this.getMainQuiver().withdrawArrows(item, item.getItemMeta(), event.getPlayer(), item.getItemMeta().getPersistentDataContainer());
    }

    public void onChangeState(ItemStack itemStack) {
        this.getMainQuiver().changeState(itemStack, itemStack.getItemMeta(), itemStack.getItemMeta().getPersistentDataContainer());
    }

    public void onBowShoot(EntityShootBowEvent event, ItemStack itemStack, boolean checkInfinity) {
        this.getMainQuiver().bowShoot(event, itemStack, checkInfinity);
    }

    public NamespacedKey getStorageKey() {
        return this.storageKey;
    }

    public NamespacedKey getStorageKey2() {
        return this.storageKey2;
    }

    public NamespacedKey getStorageKey3() {
        return this.storageKey3;
    }

    public MainQuiver getMainQuiver() {
        return this.mainQuiver;
    }

    public int getQuiverSize() {
        return this.quiverSize;
    }

    public ItemStack getArrowType() {
        return this.arrowType;
    }
}

