/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.mysteriousitems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import ne.fnfal113.fnamplifications.mysteriousitems.abstracts.AbstractStick;
import ne.fnfal113.fnamplifications.mysteriousitems.implementation.MainStick;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MysteryStick
extends AbstractStick {
    private final MainStick mainStick = new MainStick(Keys.STICK_1_EXP_LEVELS, Keys.STICK_1_DAMAGE, this.enchantments(), this.weaponLore(), this.stickLore(), 1, 5);
    private final Material material;

    @ParametersAreNonnullByDefault
    public MysteryStick(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Material material) {
        super(itemGroup, item, recipeType, recipe);
        this.material = material;
    }

    @Override
    public Map<Enchantment, Integer> enchantments() {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        enchantments.put(Enchantment.SWEEPING_EDGE, 2);
        enchantments.put(Enchantment.DAMAGE_ALL, 3);
        enchantments.put(Enchantment.FIRE_ASPECT, 2);
        return enchantments;
    }

    @Override
    public String weaponLore() {
        return ChatColor.GOLD + "What is this sorcery?";
    }

    @Override
    public String stickLore() {
        return ChatColor.WHITE + "I wonder what this stick does";
    }

    @Override
    public void interact(PlayerInteractEvent e) {
        this.getMainStick().onInteract(e, this.getMaterial());
    }

    @Override
    public void onSwing(EntityDamageByEntityEvent event) {
        Player player = (Player)event.getDamager();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != this.getMaterial()) {
            return;
        }
        if (this.getMainStick().onSwing(item, player, event.getDamage(), 27, 1)) {
            LivingEntity victim = (LivingEntity)event.getEntity();
            victim.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 80, 0, false, false, false));
            player.sendMessage(Utils.colorTranslator("&cMystery effects was applied to your enemy"));
        }
    }

    public MainStick getMainStick() {
        return this.mainStick;
    }

    public Material getMaterial() {
        return this.material;
    }
}

