/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems.implementation;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.List;
import ne.fnfal113.fnamplifications.gems.implementation.Gem;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class UpgradedGem
extends Gem {
    private final NamespacedKey key;

    public UpgradedGem(SlimefunItem sfItem, ItemStack itemToSocket, Player p) {
        super(sfItem, itemToSocket, p);
        this.key = Keys.createKey(sfItem.getId().toLowerCase() + "_gem_tier");
    }

    public void upgradeExistingGem(InventoryClickEvent event, ItemStack gemItem, int gemTier) {
        ItemMeta meta = this.getItemStackToSocket().getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        int itemTier = (Integer)container.getOrDefault(this.getKey(), PersistentDataType.INTEGER, (Object)4);
        if (this.isSameGem(this.getItemStackToSocket())) {
            if (itemTier - 1 == gemTier) {
                this.upgradeItem(gemTier, gemItem.getItemMeta().getDisplayName());
            } else {
                this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.BLOCK_NOTE_BLOCK_BIT, 1.0f, 1.0f);
                this.getPlayer().sendMessage(Utils.colorTranslator("&eGem tier not compatible! must be in order!"));
            }
        } else {
            this.getPlayer().sendMessage(Utils.colorTranslator("&eYou do not have a similar gem that can be upgraded!"));
        }
        event.setCancelled(true);
    }

    public void upgradeItem(int itemTier, String gemDisplayName) {
        ItemStack itemStack = this.getItemStackToSocket();
        ItemMeta meta = itemStack.getItemMeta();
        List lore = meta.getLore();
        this.getPlayer().setItemOnCursor(new ItemStack(Material.AIR));
        if (lore != null) {
            for (int i = 0; i < lore.size(); ++i) {
                if (!((String)lore.get(i)).contains(Utils.colorTranslator(this.getSfItemName().substring(0, this.getSfItemName().lastIndexOf(" ") + 2)))) continue;
                lore.set(i, ChatColor.RED + "\u25ec " + gemDisplayName);
            }
            meta.setLore(lore);
            meta.getPersistentDataContainer().set(this.key, PersistentDataType.INTEGER, (Object)itemTier);
            itemStack.setItemMeta(meta);
            this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_DRAGON_FIREBALL_EXPLODE, 1.0f, 1.0f);
        }
    }

    public NamespacedKey getKey() {
        return this.key;
    }
}

