/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems.implementation;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class Gem {
    private final SlimefunItem slimefunItem;
    private final ItemStack itemStackToSocket;
    private final String sfItemName;
    private final String gemID;
    private final Player player;
    private final NamespacedKey key1;
    private final NamespacedKey key2;

    @ParametersAreNonnullByDefault
    public Gem(SlimefunItem sfItem, ItemStack itemToSocket, Player p) {
        this.slimefunItem = sfItem;
        this.itemStackToSocket = itemToSocket;
        this.sfItemName = sfItem.getItemName();
        this.gemID = sfItem.getId();
        this.player = p;
        this.key1 = Keys.createKey(sfItem.getId().toLowerCase());
        this.key2 = Keys.createKey(itemToSocket.getType().toString().toLowerCase() + "_socket_amount");
    }

    public void onDrag(InventoryClickEvent event, boolean retaliateWeapon) {
        ItemMeta meta = this.getItemStackToSocket().getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (this.checkGemAmount(container, this.getItemStackToSocket()) < 5) {
            if (!this.isSameGem(this.getItemStackToSocket())) {
                this.getPlayer().setItemOnCursor(new ItemStack(Material.AIR));
                this.socketItem();
                if (retaliateWeapon) {
                    this.retaliateWeapon();
                }
            } else {
                this.getPlayer().sendMessage(Utils.colorTranslator("&6Your item has " + this.getSfItemName() + " &6socketed already!"));
                this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_BAT_TAKEOFF, 1.0f, 1.0f);
            }
        } else {
            this.getPlayer().sendMessage(Utils.colorTranslator("&eOnly 5 gems per item is allowed!"));
            this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_BLAZE_HURT, 1.0f, 1.0f);
        }
        event.setCancelled(true);
    }

    public void socketItem() {
        String name = this.getSfItemName();
        ItemStack itemStack = this.getItemStackToSocket();
        ItemMeta meta = itemStack.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        int amountOfGems = (Integer)pdc.getOrDefault(this.getKey2(), PersistentDataType.INTEGER, (Object)0);
        if (amountOfGems == 0) {
            ArrayList<String> lore = meta.hasLore() ? meta.getLore() : new ArrayList<String>();
            lore.add("");
            lore.add(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4| &d&lGems &c|\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5"));
            lore.add(ChatColor.RED + "\u25ec " + name);
            lore.add(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4&c\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5"));
            meta.setLore(lore);
        } else {
            List lore2 = meta.getLore();
            if (lore2 != null) {
                for (int i = 0; i < lore2.size(); ++i) {
                    if (!((String)lore2.get(i)).startsWith(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4| &d&lGems &c|\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5"))) continue;
                    lore2.add(i + 1, ChatColor.RED + "\u25ec " + name);
                }
                meta.setLore(lore2);
            }
        }
        pdc.set(this.getKey1(), PersistentDataType.STRING, (Object)this.getGemID());
        pdc.set(this.getKey2(), PersistentDataType.INTEGER, (Object)(amountOfGems + 1));
        itemStack.setItemMeta(meta);
        this.getPlayer().sendMessage(Utils.colorTranslator("&eSuccessfully bound " + name + " &eto " + itemStack.getType().name().replace("_", " ").toLowerCase(Locale.ROOT)));
        this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_BLAZE_SHOOT, 1.0f, 1.0f);
    }

    public int checkGemAmount(PersistentDataContainer pdc, ItemStack itemStack) {
        return (Integer)pdc.getOrDefault(Keys.createKey(itemStack.getType().toString().toLowerCase() + "_socket_amount"), PersistentDataType.INTEGER, (Object)0);
    }

    public boolean isSameGem(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.isEmpty()) {
            return false;
        }
        return container.has(this.getKey1(), PersistentDataType.STRING);
    }

    public void retaliateWeapon() {
        ItemMeta meta = this.getItemStackToSocket().getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(Keys.RETURN_WEAPON_KEY, PersistentDataType.STRING, (Object)"true");
        this.getItemStackToSocket().setItemMeta(meta);
    }

    public SlimefunItem getSlimefunItem() {
        return this.slimefunItem;
    }

    public ItemStack getItemStackToSocket() {
        return this.itemStackToSocket;
    }

    public String getSfItemName() {
        return this.sfItemName;
    }

    public String getGemID() {
        return this.gemID;
    }

    public Player getPlayer() {
        return this.player;
    }

    public NamespacedKey getKey1() {
        return this.key1;
    }

    public NamespacedKey getKey2() {
        return this.key2;
    }
}

