/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.staffs.abstracts.AbstractStaff;
import ne.fnfal113.fnamplifications.staffs.handlers.EntityStaffImpl;
import ne.fnfal113.fnamplifications.staffs.implementations.MainStaff;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class StaffOfLocomotion
extends AbstractStaff
implements EntityStaffImpl {
    private final Map<PersistentDataContainer, LivingEntity> ENTITY_OWNER = new HashMap<PersistentDataContainer, LivingEntity>();
    private final NamespacedKey defaultUsageKey = new NamespacedKey((Plugin)FNAmplifications.getInstance(), "movestaff");
    private final NamespacedKey defaultUsageKey2 = new NamespacedKey((Plugin)FNAmplifications.getInstance(), "identifier");
    private final MainStaff mainStaff = new MainStaff(this.getStorageKey(), this.getId());

    public StaffOfLocomotion(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 10);
    }

    @Nonnull
    public NamespacedKey getStorageKey() {
        return this.defaultUsageKey;
    }

    @Nonnull
    public NamespacedKey getStorageKey2() {
        return this.defaultUsageKey2;
    }

    @Override
    public void onEntityClick(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (event.getRightClicked() instanceof Player) {
            player.sendMessage(Utils.colorTranslator("&cStaff is not allowed to move players!"));
            return;
        }
        if (!(event.getRightClicked() instanceof LivingEntity)) {
            player.sendMessage(Utils.colorTranslator("&cYou right clicked an invalid entity"));
            return;
        }
        LivingEntity en = (LivingEntity)event.getRightClicked();
        ItemStack item = player.getInventory().getItemInMainHand();
        ItemMeta meta = item.getItemMeta();
        if (!this.hasPermissionToCast(meta.getDisplayName(), player, en.getLocation())) {
            return;
        }
        PersistentDataContainer data = meta.getPersistentDataContainer();
        if (!this.ENTITY_OWNER.containsValue(en)) {
            this.ENTITY_OWNER.remove(data);
            data.set(this.getStorageKey2(), PersistentDataType.DOUBLE, (Object)Math.random());
            this.ENTITY_OWNER.put(data, en);
            Utils.updateValueByPdc(item, meta, en.getName(), "Entity stored: ", "&e", "", " entity");
            Objects.requireNonNull(player.getLocation().getWorld()).playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_MIRROR_MOVE, 1.0f, 1.0f);
        } else {
            player.sendMessage(Utils.colorTranslator("&eThis entity has been stored already by others!"));
        }
    }

    @Override
    public void onClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer data = meta.getPersistentDataContainer();
        Block block = player.getTargetBlockExact(100);
        if (block == null) {
            return;
        }
        if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), block, Interaction.INTERACT_BLOCK)) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission to teleport entity there!");
            return;
        }
        if (this.ENTITY_OWNER.get(data) == null) {
            player.sendMessage("You haven't right clicked an entity or Entity ID changed after server restart");
            return;
        }
        if (this.ENTITY_OWNER.containsKey(data)) {
            LivingEntity entity = this.ENTITY_OWNER.get(data);
            entity.teleport(block.getLocation().add(0.5, 1.0, 0.5));
            this.ENTITY_OWNER.remove(data);
            Utils.updateValueByPdc(item, meta, "none", "Entity stored: ", "&e", "", "");
            this.mainStaff.updateMeta(item, meta, player);
        }
    }
}

