/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.handlers.GemUpgrade;
import ne.fnfal113.fnamplifications.gems.handlers.OnDamageHandler;
import ne.fnfal113.fnamplifications.gems.implementation.Gem;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class InfernoGem
extends AbstractGem
implements OnDamageHandler,
GemUpgrade {
    public InfernoGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 16);
    }

    @Override
    public void onDrag(InventoryClickEvent event, Player player, SlimefunItem slimefunItem, ItemStack currentItem) {
        if (WeaponArmorEnum.SWORDS.isTagged(currentItem.getType())) {
            if (this.isUpgradeGem(event.getCursor(), this.getId())) {
                this.upgradeGem(slimefunItem, currentItem, event, player, this.getId());
            } else {
                new Gem(slimefunItem, currentItem, player).onDrag(event, false);
            }
        } else {
            player.sendMessage(Utils.colorTranslator("&eInvalid item to socket! Gem works on swords only"));
        }
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent event, ItemStack itemStack) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)event.getEntity();
        int random = ThreadLocalRandom.current().nextInt(100);
        if (random < this.getChance() / this.getTier(itemStack, this.getId())) {
            livingEntity.setFireTicks(60);
            if (event.getDamager() instanceof Player) {
                this.sendGemMessage((Player)event.getDamager(), this.getItemName());
            }
        }
        for (Entity entity : livingEntity.getNearbyEntities(7.0, 4.0, 7.0)) {
            if (random >= this.getChance() || entity.getUniqueId() == event.getDamager().getUniqueId()) continue;
            entity.setFireTicks(60);
        }
    }
}

