/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.events.GuardianSpawnEvent;
import ne.fnfal113.fnamplifications.gems.handlers.GemUpgrade;
import ne.fnfal113.fnamplifications.gems.handlers.OnDamageHandler;
import ne.fnfal113.fnamplifications.gems.implementation.Gem;
import ne.fnfal113.fnamplifications.gems.implementation.GuardianTask;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.Bukkit;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Flying;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class GuardianGem
extends AbstractGem
implements OnDamageHandler,
GemUpgrade {
    private final int chance;
    private final Map<UUID, Zombie> entityUUIDMap = new HashMap<UUID, Zombie>();
    private final Map<UUID, BukkitTask> runnableMap = new HashMap<UUID, BukkitTask>();

    public GuardianGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 8);
        this.chance = FNAmplifications.getInstance().getConfigManager().getValueById(this.getId() + "-percent-chance");
    }

    @Override
    public void onDrag(InventoryClickEvent event, Player player) {
        if (event.getCursor() == null) {
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)event.getCursor());
        if (slimefunItem != null && currentItem != null) {
            if (WeaponArmorEnum.CHESTPLATE.isTagged(currentItem.getType())) {
                if (this.isUpgradeGem(event.getCursor(), this.getId())) {
                    this.upgradeGem(slimefunItem, currentItem, event, player, this.getId());
                } else {
                    new Gem(slimefunItem, currentItem, player).onDrag(event, false);
                }
            } else {
                player.sendMessage(Utils.colorTranslator("&eInvalid item to socket! Gem works on chestplate only"));
            }
        }
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent event, ItemStack itemStack) {
        if (event.isCancelled()) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (event.getDamager() instanceof Phantom || event.getDamager() instanceof Flying || event.getDamager() instanceof EnderDragon) {
            return;
        }
        if (this.runnableMap.containsKey(player.getUniqueId()) && this.runnableMap.get(player.getUniqueId()).isCancelled()) {
            this.entityUUIDMap.remove(player.getUniqueId());
            this.runnableMap.remove(player.getUniqueId());
            return;
        }
        if (!this.entityUUIDMap.containsKey(player.getUniqueId())) {
            if (ThreadLocalRandom.current().nextInt(100) < this.getChance() / this.getTier(itemStack, this.getId())) {
                GuardianTask guardianTask = new GuardianTask(player, event);
                GuardianSpawnEvent guardianSpawnEvent = new GuardianSpawnEvent(player, guardianTask.getZombie(), event.getDamager());
                Bukkit.getPluginManager().callEvent((Event)guardianSpawnEvent);
                if (guardianSpawnEvent.isCancelled()) {
                    guardianSpawnEvent.getZombieGuardian().remove();
                    return;
                }
                this.sendGemMessage(player, this.getItemName());
                this.runnableMap.put(player.getUniqueId(), guardianTask.runTaskTimer((Plugin)FNAmplifications.getInstance(), 5L, 3L));
                this.entityUUIDMap.put(player.getUniqueId(), guardianTask.getZombie());
            }
        } else {
            Zombie zombie = this.entityUUIDMap.get(player.getUniqueId());
            if (zombie.getTarget() != null && !zombie.getTarget().isDead()) {
                return;
            }
            boolean isDamagerLivingEntity = event.getDamager() instanceof LivingEntity;
            if (isDamagerLivingEntity && event.getDamager().getPersistentDataContainer().has(Keys.GUARDIAN_KEY, PersistentDataType.STRING)) {
                zombie.setTarget((LivingEntity)Bukkit.getPlayer((String)((String)event.getDamager().getPersistentDataContainer().get(Keys.GUARDIAN_KEY, PersistentDataType.STRING))));
            } else if (event.getDamager() instanceof Projectile) {
                if (((Projectile)event.getDamager()).getShooter() instanceof LivingEntity) {
                    zombie.setTarget((LivingEntity)((Projectile)event.getDamager()).getShooter());
                }
            } else if (isDamagerLivingEntity) {
                zombie.setTarget((LivingEntity)event.getDamager());
            }
        }
    }

    public int getChance() {
        return this.chance;
    }
}

