/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.materialgenerators.implementations;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import ne.fnfal113.fnamplifications.ExtraUtils.interfaces.InventoryBlock;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CustomMaterialGenerator
extends SlimefunItem
implements InventoryBlock {
    private static final Map<BlockPosition, Integer> generatorProgress = new HashMap<BlockPosition, Integer>();
    private static final Map<BlockPosition, Integer> generatorStatus = new HashMap<BlockPosition, Integer>();
    private static final CustomItemStack NOT_GENERATING = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cNot Generating", new String[]{"&ePlace a chest above first!"});
    private static final CustomItemStack NOT_GENERATING_FULL = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cNot Generating", new String[]{"&eChest inventory full!"});
    private static final CustomItemStack CONDITION = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cCurrent Condition: ", new String[]{"&ePlace a chest above first!"});
    private static final CustomItemStack CONDITION_BROKEN = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cCurrent Condition: ", new String[]{"&eGenerator is broken! please repair!", "&eDestroy the block and craft a new one"});
    private ItemStack item;
    private String material;

    @ParametersAreNonnullByDefault
    public CustomMaterialGenerator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int tickRate) {
        super(itemGroup, item, recipeType, recipe);
        this.createPreset(this, this.getInventoryTitle(), blockMenuPreset -> {
            for (int i = 0; i < 9; ++i) {
                blockMenuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            blockMenuPreset.addItem(4, (ItemStack)NOT_GENERATING);
            blockMenuPreset.addItem(0, (ItemStack)CONDITION);
        });
        try {
            FNAmplifications.getInstance().getConfigManager().setIntegerValues(item.getItemId(), tickRate, "material-gen-tickrate");
            Utils.setLore(this.getItem(), this.getId(), "", "ticks", "&6", " ticks");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                BlockStorage.addBlockInfo((Location)e.getBlock().getLocation(), (String)"generator_status", (String)"100");
                generatorStatus.put(new BlockPosition(e.getBlock().getLocation()), 100);
            }
        }, new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                if (BlockStorage.getLocationInfo((Location)e.getBlock().getLocation(), (String)"generator_status") != null) {
                    e.setDropItems(false);
                    e.setCancelled(true);
                    e.getBlock().setType(Material.AIR);
                    e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), SlimefunItem.getById((String)(BlockStorage.getLocationInfo((Location)e.getBlock().getLocation(), (String)"id") + "_BROKEN")).getItem());
                    generatorStatus.remove(new BlockPosition(e.getBlock().getLocation()));
                    BlockStorage.clearBlockInfo((Location)e.getBlock().getLocation());
                } else {
                    e.getPlayer().sendMessage(Utils.colorTranslator("&cSlimefun block data is missing! Please ask for replacement from your server admin"));
                }
            }
        }});
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            @ParametersAreNonnullByDefault
            public void tick(Block b, SlimefunItem sf, Config data) {
                CustomMaterialGenerator.this.tick(b);
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    public void tick(@Nonnull Block b) {
        BlockMenu invMenu = BlockStorage.getInventory((Block)b);
        Block targetBlock = b.getRelative(BlockFace.UP);
        BlockPosition pos = new BlockPosition(b);
        if (!generatorStatus.containsKey(pos)) {
            if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"generator_status") != null) {
                generatorStatus.put(pos, Integer.parseInt(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"generator_status")));
            } else {
                BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"generator_status", (String)"100");
                generatorStatus.put(pos, 100);
            }
        }
        if (targetBlock.getType() == Material.CHEST) {
            BlockState state = PaperLib.getBlockState((Block)targetBlock, (boolean)false).getState();
            if (state instanceof InventoryHolder && generatorStatus.get(pos) > 0) {
                Inventory inv = ((InventoryHolder)state).getInventory();
                if (inv.firstEmpty() != -1) {
                    int progress = generatorProgress.getOrDefault(pos, 0);
                    int generatorCondition = generatorStatus.get(pos);
                    if (invMenu.toInventory() != null && invMenu.hasViewer()) {
                        invMenu.replaceExistingItem(4, (ItemStack)new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, "&aGenerating Material", new String[]{"", "&bMaterial: " + this.material, "&bRate: " + ChatColor.GREEN + FNAmplifications.getInstance().getConfigManager().getValueById(this.getId()) + " &aticks", "", "&2Progress: " + progress + "/" + FNAmplifications.getInstance().getConfigManager().getValueById(this.getId())}));
                        if (generatorCondition > 0) {
                            if (generatorCondition > 75 && generatorCondition <= 100) {
                                invMenu.replaceExistingItem(0, (ItemStack)new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, "&aCurrent Condition:", new String[]{"", "&eIn best condition (" + generatorCondition + "%)"}));
                            } else if (generatorCondition > 50 && generatorCondition < 75) {
                                invMenu.replaceExistingItem(0, (ItemStack)new CustomItemStack(Material.YELLOW_STAINED_GLASS_PANE, "&aCurrent Condition:", new String[]{"", "&eIn good condition (" + generatorCondition + "%)"}));
                            } else if (generatorCondition > 25 && generatorCondition < 50) {
                                invMenu.replaceExistingItem(0, (ItemStack)new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, "&aCurrent Condition:", new String[]{"", "&eIn bad condition (" + generatorCondition + "%)"}));
                            } else if (generatorCondition < 25) {
                                invMenu.replaceExistingItem(0, (ItemStack)new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&aCurrent Condition:", new String[]{"", "&eIn worst condition (" + generatorCondition + "%)"}));
                            }
                        } else {
                            invMenu.replaceExistingItem(0, (ItemStack)new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&aCurrent Condition:", new String[]{"", "&eBroken generator (" + generatorStatus.get(pos) + "%)"}));
                        }
                    }
                    if (progress >= FNAmplifications.getInstance().getConfigManager().getValueById(this.getId())) {
                        progress = 0;
                        if (ThreadLocalRandom.current().nextInt(100) < 32 && generatorCondition > 0) {
                            BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"generator_status", (String)String.valueOf(generatorCondition - 1));
                            generatorStatus.put(pos, generatorCondition - 1);
                        }
                        inv.addItem(new ItemStack[]{this.item});
                    } else {
                        ++progress;
                    }
                    generatorProgress.put(pos, progress);
                } else if (invMenu.toInventory() != null && invMenu.hasViewer()) {
                    invMenu.replaceExistingItem(4, (ItemStack)NOT_GENERATING_FULL);
                }
            } else if (invMenu.toInventory() != null && invMenu.hasViewer()) {
                invMenu.replaceExistingItem(4, ChestMenuUtils.getBackground());
                invMenu.replaceExistingItem(0, (ItemStack)CONDITION_BROKEN);
            }
        } else if (invMenu.toInventory() != null && invMenu.hasViewer()) {
            invMenu.replaceExistingItem(4, (ItemStack)NOT_GENERATING);
            invMenu.replaceExistingItem(0, (ItemStack)CONDITION);
        }
    }

    @Nonnull
    public String getInventoryTitle() {
        return this.getItemName();
    }

    public final CustomMaterialGenerator setItem(@Nonnull Material material) {
        this.item = new ItemStack(material);
        return this;
    }

    public final CustomMaterialGenerator getMaterialName(String materialName) {
        this.material = materialName;
        return this;
    }

    @Override
    public int[] getInputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }
}

