/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.handlers.OnRightClickHandler;
import ne.fnfal113.fnamplifications.gems.implementation.Gem;
import ne.fnfal113.fnamplifications.gems.implementation.ThrowableWeapon;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AxeThrowieGem
extends AbstractGem
implements OnRightClickHandler {
    private final ThrowableWeapon throwableWeapon = new ThrowableWeapon();

    public AxeThrowieGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    public void onDrag(InventoryClickEvent event, Player player) {
        if (event.getCursor() == null) {
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)event.getCursor());
        if (slimefunItem != null && currentItem != null) {
            if (WeaponArmorEnum.AXES.isTagged(currentItem.getType())) {
                new Gem(slimefunItem, currentItem, player).onDrag(event, false);
            } else {
                player.sendMessage(Utils.colorTranslator("&eInvalid item to socket! Gem works on axes only"));
            }
        }
    }

    @Override
    public void onRightClick(Player player) {
        if (player.isSneaking()) {
            return;
        }
        if (!this.hasPermissionToThrow(player)) {
            player.sendMessage(Utils.colorTranslator("&c&l[FNAmpli&b&lfications] > &eYou don't have the permission to throw here!"));
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        PersistentDataContainer pdc = itemStack.getItemMeta().getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)FNAmplifications.getInstance(), "return_weapon");
        this.throwableWeapon.throwWeapon(player, this.throwableWeapon.spawnArmorstand(player, itemStack.clone(), false), itemStack.clone(), true, false, false, Boolean.parseBoolean((String)pdc.getOrDefault(key, PersistentDataType.STRING, (Object)"false")));
        itemStack.setAmount(0);
    }
}

