/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs.implementations;

import java.util.Objects;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class MainStaff {
    private final NamespacedKey storageKey;
    private final String id;

    public MainStaff(NamespacedKey storageKey, String id) {
        this.storageKey = storageKey;
        this.id = id;
    }

    public void updateMeta(ItemStack item, ItemMeta meta, Player player) {
        PersistentDataContainer max_Uses = meta.getPersistentDataContainer();
        int uses_Left = (Integer)max_Uses.getOrDefault(this.getStorageKey(), PersistentDataType.INTEGER, (Object)FNAmplifications.getInstance().getConfigManager().getValueById(this.getId() + "-max-uses"));
        int decrement = uses_Left - 1;
        if (decrement > 0) {
            max_Uses.set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)decrement);
            Utils.updateValueByPdc(item, meta, String.valueOf(decrement), "Uses: ", "&e", "", " left");
        } else {
            player.getInventory().setItemInMainHand(null);
            player.sendMessage(Utils.colorTranslator(meta.getDisplayName() + " &d&lhas reached max uses!"));
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        }
        Objects.requireNonNull(player.getLocation().getWorld()).playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 1.0f, 1.0f);
    }

    public NamespacedKey getStorageKey() {
        return this.storageKey;
    }

    public String getId() {
        return this.id;
    }
}

