/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.mysteriousitems.implementation;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.ParametersAreNonnullByDefault;
import ne.fnfal113.fnamplifications.utils.Utils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MainStick {
    public final NamespacedKey storageKey;
    public final NamespacedKey storageKey2;
    public final Map<Enchantment, Integer> enchantmentMap;
    public final String weaponLore;
    public final String stickLore;
    public final int effectCount;
    public final int requiredLevel;

    @ParametersAreNonnullByDefault
    public MainStick(NamespacedKey key1, NamespacedKey key2, Map<Enchantment, Integer> enchantmentMap, String weaponLore, String stickLore) {
        this(key1, key2, enchantmentMap, weaponLore, stickLore, 0, 0);
    }

    @ParametersAreNonnullByDefault
    public MainStick(NamespacedKey key1, NamespacedKey key2, Map<Enchantment, Integer> enchantmentMap, String weaponLore, String stickLore, int effectCount, int levelReq) {
        this.storageKey = key1;
        this.storageKey2 = key2;
        this.enchantmentMap = enchantmentMap;
        this.weaponLore = weaponLore;
        this.stickLore = stickLore;
        this.effectCount = effectCount;
        this.requiredLevel = levelReq;
    }

    public int getPdc(PersistentDataContainer pdc, NamespacedKey key) {
        return (Integer)pdc.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
    }

    @ParametersAreNonnullByDefault
    public void onInteract(PlayerInteractEvent e, Material material) {
        if (e.getPlayer().getLevel() < this.getRequiredLevel()) {
            this.darkenVision(e.getPlayer(), this.getRequiredLevel());
            return;
        }
        Player player = e.getPlayer();
        ItemStack item1 = player.getInventory().getItemInMainHand();
        ItemMeta meta = item1.getItemMeta();
        List lore2 = meta.getLore();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        this.getEnchantmentMap().forEach((Key, Value) -> meta.addEnchant(Key, Value.intValue(), true));
        meta.setUnbreakable(true);
        meta.setLore(this.loreUpdate(lore2, this.getPdc(pdc, this.getStorageKey2()), this.getPdc(pdc, this.getStorageKey()), this.getWeaponLore()));
        item1.setItemMeta(meta);
        if (item1.getType() != material) {
            item1.setType(material);
            player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_MIRROR_MOVE, 1.0f, 1.0f);
            player.getWorld().playEffect(player.getLocation().add(0.3, 0.4, 0.45), Effect.ENDER_SIGNAL, 1);
            player.getWorld().spawnParticle(Particle.FLASH, player.getLocation().add(0.3, 0.4, 0.45), 2, 0.1, 0.1, 0.1, 0.1);
        }
    }

    public void transformWeapon(Player p, ItemStack item, SlimefunItemStack slimefunItem, String finalLore, int incrementLevel, int damageAmount, boolean isLevelDeducted) {
        CustomItemStack item2 = new CustomItemStack((ItemStack)slimefunItem);
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        int xpAmount = this.getPdc(pdc, this.getStorageKey());
        int damageInflicted = damageAmount + this.getPdc(pdc, this.getStorageKey2());
        pdc.set(this.getStorageKey2(), PersistentDataType.INTEGER, (Object)damageInflicted);
        if (isLevelDeducted) {
            int amount = ++xpAmount + incrementLevel;
            pdc.set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)amount);
            meta.setLore(this.loreUpdate(lore, damageInflicted, amount, finalLore));
        } else {
            meta.setLore(this.loreUpdate(lore, damageInflicted, xpAmount, finalLore));
        }
        item.setItemMeta(meta);
        if (p.getLevel() <= this.getRequiredLevel()) {
            if (lore.size() >= 4) {
                lore.subList(3, lore.size()).clear();
            }
            meta.setLore(lore);
            meta.getEnchants().forEach((enchant, value) -> meta.removeEnchant(enchant));
            item.setItemMeta(meta);
            item.setType(item2.getType());
        }
    }

    public boolean onSwing(ItemStack item, SlimefunItemStack slimefunItemStack, Player player, double damageAmount, int chance, int levelDeduction) {
        if (player.getLevel() >= this.getRequiredLevel()) {
            if (ThreadLocalRandom.current().nextInt(100) < chance) {
                player.setLevel(player.getLevel() - levelDeduction);
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)Utils.colorTranslator("&d" + levelDeduction + " xp levels has been consumed from you")));
                this.transformWeapon(player, item, slimefunItemStack, this.getStickLore(), levelDeduction - 1, (int)damageAmount, true);
                return true;
            }
            this.transformWeapon(player, item, slimefunItemStack, this.getStickLore(), levelDeduction - 1, (int)damageAmount, false);
        } else {
            this.darkenVision(player, this.getRequiredLevel());
        }
        return false;
    }

    public List<String> loreUpdate(List<String> lore2, int get_Damage, int xpamount, String lore) {
        if (lore2.size() == 1) {
            lore2.remove(0);
            lore2.add(lore);
            lore2.add(ChatColor.YELLOW + "Total Exp Levels Consumed: " + ChatColor.WHITE + xpamount);
            lore2.add(ChatColor.YELLOW + "Total Damage inflicted: " + ChatColor.WHITE + get_Damage);
        } else {
            lore2.set(0, lore);
            lore2.set(1, ChatColor.YELLOW + "Total Exp Levels Consumed: " + ChatColor.WHITE + xpamount);
            lore2.set(2, ChatColor.YELLOW + "Total Damage inflicted: " + ChatColor.WHITE + get_Damage);
        }
        if (lore2.size() < 4) {
            lore2.add("");
            lore2.add(Utils.colorTranslator("&c\u25e2\u25e4\u25e2\u25e4\u25e2\u25e4\u25e2\u25e4| &4&lEffects &f|\u25e5\u25e3\u25e5\u25e3\u25e5\u25e3\u25e5\u25e3"));
            lore2.add(ChatColor.BLUE + "\u25c6 " + this.getEffectCount() + " Mystery effect/s");
            lore2.add(Utils.colorTranslator("&c\u25e2\u25e4\u25e2\u25e4\u25e2\u25e4\u25e2\u25e4| &4\u25e2\u25e4\u25e4\u25e5\u25e4\u25e5\u25e4\u25e5\u25e4\u25e5\u25e5\u25e3 &f|\u25e5\u25e3\u25e5\u25e3\u25e5\u25e3\u25e5\u25e3"));
        }
        return lore2;
    }

    @ParametersAreNonnullByDefault
    public void darkenVision(Player player, int level) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 300, 2, false, false));
        player.sendTitle(ChatColor.DARK_RED + "Your vision darkens!", ChatColor.RED + "The stick is unpredictable", 45, 120, 135);
        player.sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "[FNAmpli" + ChatColor.AQUA + "" + ChatColor.BOLD + "fications] > " + ChatColor.YELLOW + "You're too weak, make sure your exp level is higher than " + level);
    }

    public NamespacedKey getStorageKey() {
        return this.storageKey;
    }

    public NamespacedKey getStorageKey2() {
        return this.storageKey2;
    }

    public Map<Enchantment, Integer> getEnchantmentMap() {
        return this.enchantmentMap;
    }

    public String getWeaponLore() {
        return this.weaponLore;
    }

    public String getStickLore() {
        return this.stickLore;
    }

    public int getEffectCount() {
        return this.effectCount;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }
}

