/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.machines.implementation;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import ne.fnfal113.fnamplifications.machines.abstracts.AbstractJukeBox;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Jukebox;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class JukeBox
extends AbstractJukeBox {
    private final int lowerBound;
    private final int upperBound;
    private final int secondLowerBound;
    private final int secondUpperBound;
    private final int defaultSlot;
    private boolean newMusic = false;
    private final boolean secondBound;
    private static final Map<Location, JukeboxCache> CACHE_MAP = new HashMap<Location, JukeboxCache>();

    public JukeBox(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int lowerBound, int upperBound, int defaultSlot, int secondLowerBound, int secondUpperBound, boolean hasSecondBound) {
        super(itemGroup, item, recipeType, recipe);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.secondLowerBound = secondLowerBound;
        this.secondUpperBound = secondUpperBound;
        this.defaultSlot = defaultSlot;
        this.secondBound = hasSecondBound;
    }

    @Override
    public void changeStatus(BlockMenu invMenu, int currentSlot) {
        invMenu.replaceExistingItem(49, (ItemStack)new CustomItemStack(Material.MAGENTA_STAINED_GLASS_PANE, "&dNo music disc is being played", new String[]{"&ePlace a music disc then click", "&eplay button or left/right arrows"}));
    }

    @Override
    public void toggleOnOrOff(BlockMenu blockMenu) {
        Location location = blockMenu.getLocation();
        JukeboxCache cache = JukeBox.getCACHE_MAP().get(location);
        cache.isOn = !cache.isOn;
        BlockStorage.addBlockInfo((Location)location, (String)"toggled_On", (String)String.valueOf(cache.isOn));
        blockMenu.replaceExistingItem(50, (ItemStack)(cache.isOn ? this.TOGGLED_ON : this.TOGGLED_OFF));
        JukeBox.getCACHE_MAP().put(location, cache);
    }

    @Override
    public void previousDiscButton(@Nullable Player player, BlockMenu menu, boolean goBackToDefaultSlot) {
        Location location = menu.getLocation();
        JukeboxCache cache = JukeBox.getCACHE_MAP().get(location);
        Jukebox jukebox = (Jukebox)menu.getBlock().getState();
        if (cache.isOn) {
            if (this.isSlotNotNull(menu, cache, -1)) {
                this.playCurrentSlot(menu, cache, jukebox, location, -1);
            } else {
                this.isOutOfBounds(menu, jukebox, cache, location, -1);
            }
        } else if (player != null) {
            player.sendMessage(Utils.colorTranslator("&eJukebox is turned off, please turn it on"));
        }
    }

    @Override
    public void nextDiscButton(@Nullable Player player, BlockMenu menu) {
        Location location = menu.getLocation();
        JukeboxCache cache = JukeBox.getCACHE_MAP().get(location);
        Jukebox jukebox = (Jukebox)menu.getBlock().getState();
        if (cache.isOn) {
            if (this.isSlotNotNull(menu, cache, 1)) {
                this.playCurrentSlot(menu, cache, jukebox, location, 1);
            } else {
                this.isOutOfBounds(menu, jukebox, cache, location, 1);
            }
        } else if (player != null) {
            player.sendMessage(Utils.colorTranslator("&eJukebox is turned off, please turn it on"));
        }
    }

    @Override
    public void playOrStopButton(Player player, BlockMenu menu) {
        Location location = menu.getLocation();
        JukeboxCache cache = JukeBox.getCACHE_MAP().get(location);
        Jukebox jukebox = (Jukebox)menu.getBlock().getState();
        if (cache.isOn) {
            if (cache.isPlaying) {
                cache.isPlaying = false;
                cache.itemStack = null;
                BlockStorage.addBlockInfo((Location)location, (String)"is_Playing", (String)String.valueOf(false));
                menu.replaceExistingItem(4, (ItemStack)this.STOP);
                this.stopCurrentSlot(jukebox, location, cache, menu);
                JukeBox.getCACHE_MAP().put(menu.getLocation(), cache);
            } else if (this.isSlotNotNull(menu, cache, 0)) {
                this.playCurrentSlot(menu, cache, jukebox, location, 0);
            } else {
                player.sendMessage(Utils.colorTranslator("&dCurrent slot has no music disc"));
            }
        } else {
            player.sendMessage(Utils.colorTranslator("&eJukebox is turned off, please turn it on"));
        }
    }

    @Override
    public void playCurrentSlot(BlockMenu menu, JukeboxCache cache, Jukebox jukebox, Location location, int arithmetic) {
        this.unSelectDisc(cache.itemStack != null ? cache.itemStack : menu.getItemInSlot(cache.currentSlot), menu);
        this.unSelectSlot(menu, cache);
        cache.currentSlot += arithmetic;
        cache.isPlaying = true;
        cache.itemStack = menu.getItemInSlot(cache.currentSlot);
        menu.replaceExistingItem(4, (ItemStack)this.PLAY);
        BlockStorage.addBlockInfo((Location)location, (String)"is_Playing", (String)String.valueOf(true));
        BlockStorage.addBlockInfo((Location)location, (String)"current_Slot", (String)String.valueOf(cache.currentSlot));
        this.selectDisc(menu.getItemInSlot(cache.currentSlot), menu);
        jukebox.setPlaying(menu.getItemInSlot(cache.currentSlot).getType());
        jukebox.update(true);
        this.setNewMusic(true);
        JukeBox.getCACHE_MAP().put(menu.getLocation(), cache);
    }

    @Override
    public void stopCurrentSlot(Jukebox jukebox, Location location, JukeboxCache cache, BlockMenu menu) {
        this.unSelectDisc(cache.itemStack != null ? cache.itemStack : menu.getItemInSlot(cache.currentSlot), menu);
        cache.isPlaying = false;
        cache.itemStack = null;
        menu.replaceExistingItem(4, (ItemStack)this.STOP);
        BlockStorage.addBlockInfo((Location)location, (String)"is_Playing", (String)String.valueOf(false));
        jukebox.stopPlaying();
        jukebox.setRecord(null);
        jukebox.update(true);
        JukeBox.getCACHE_MAP().put(location, cache);
    }

    @Override
    public void isOutOfBounds(BlockMenu menu, Jukebox jukebox, JukeboxCache cache, Location location, int arithmetic) {
        if (this.isSecondBound()) {
            if (cache.currentSlot + arithmetic == this.getSecondUpperBound() + 1) {
                this.changeSlot(menu, jukebox, cache, location, arithmetic, true);
                return;
            }
            if (cache.currentSlot + arithmetic <= this.getSecondUpperBound() && cache.currentSlot + arithmetic >= this.getSecondLowerBound() || cache.currentSlot + arithmetic <= this.getUpperBound() && cache.currentSlot + arithmetic >= this.getLowerBound()) {
                this.changeSlot(menu, jukebox, cache, location, arithmetic, false);
                return;
            }
            if (cache.currentSlot + arithmetic < this.getSecondLowerBound() && cache.currentSlot + arithmetic > this.getUpperBound()) {
                this.changeSlot(menu, jukebox, cache, location, arithmetic == 1 ? this.getSecondLowerBound() - this.getUpperBound() : this.getUpperBound() - this.getSecondLowerBound(), false);
                return;
            }
        }
        if (cache.currentSlot + arithmetic == this.getUpperBound() + 1) {
            this.changeSlot(menu, jukebox, cache, location, arithmetic, true);
            return;
        }
        if (this.isSlotNotNull(menu, cache, arithmetic) && cache.currentSlot == this.getDefaultSlot() && cache.isPlaying) {
            this.stopCurrentSlot(jukebox, location, cache, menu);
            this.changeSlot(menu, jukebox, cache, location, arithmetic, false);
            return;
        }
        if (cache.currentSlot + arithmetic <= this.getUpperBound() && cache.currentSlot + arithmetic >= this.getLowerBound()) {
            this.changeSlot(menu, jukebox, cache, location, arithmetic, false);
        }
    }

    @Override
    public void changeSlot(BlockMenu menu, Jukebox jukebox, JukeboxCache cache, Location location, int arithmetic, boolean goToDefaultSlot) {
        if (cache.isPlaying) {
            this.stopCurrentSlot(jukebox, location, cache, menu);
        }
        if (this.isSlotNotNull(menu, cache, arithmetic)) {
            this.playCurrentSlot(menu, cache, jukebox, location, arithmetic);
            return;
        }
        if (goToDefaultSlot) {
            this.unSelectSlot(menu, cache);
            cache.currentSlot = this.getDefaultSlot();
            if (this.isSlotNotNull(menu, cache, 0)) {
                this.playCurrentSlot(menu, cache, jukebox, location, 0);
                return;
            }
        }
        this.unSelectSlot(menu, cache);
        cache.currentSlot = goToDefaultSlot ? this.getDefaultSlot() : cache.currentSlot + arithmetic;
        BlockStorage.addBlockInfo((Location)location, (String)"current_Slot", (String)String.valueOf(cache.currentSlot));
        menu.replaceExistingItem(cache.currentSlot, (ItemStack)new CustomItemStack(Material.PINK_STAINED_GLASS_PANE, "&eNo music disc in current slot", new String[]{"&eplease change the slot"}));
        menu.reload();
        JukeBox.getCACHE_MAP().put(menu.getLocation(), cache);
    }

    @Override
    public void unSelectSlot(BlockMenu menu, JukeboxCache cache) {
        if (menu.getItemInSlot(cache.currentSlot) != null && menu.getItemInSlot(cache.currentSlot).getType() == Material.PINK_STAINED_GLASS_PANE) {
            menu.replaceExistingItem(cache.currentSlot, new ItemStack(Material.AIR));
            menu.reload();
        }
    }

    @Override
    public void selectDisc(@Nullable ItemStack itemStack, BlockMenu menu) {
        if (itemStack == null) {
            return;
        }
        ItemMeta meta = itemStack.getItemMeta().clone();
        meta.addEnchant(Enchantment.BINDING_CURSE, 0, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemStack.setItemMeta(meta);
        menu.reload();
    }

    @Override
    public void unSelectDisc(@Nullable ItemStack itemStack, BlockMenu menu) {
        if (itemStack == null) {
            return;
        }
        ItemMeta meta = itemStack.getItemMeta();
        meta.removeEnchant(Enchantment.BINDING_CURSE);
        itemStack.setItemMeta(meta);
        menu.reload();
    }

    @Override
    public boolean isSlotNotNull(BlockMenu menu, JukeboxCache cache, int arithmetic) {
        return menu.getItemInSlot(cache.currentSlot + arithmetic) != null && menu.getItemInSlot(cache.currentSlot + arithmetic).getType() != Material.AIR && this.isMusicDisc(menu.getItemInSlot(cache.currentSlot + arithmetic));
    }

    @Override
    public boolean isMusicDisc(ItemStack itemStack) {
        return Tag.ITEMS_MUSIC_DISCS.isTagged((Keyed)itemStack.getType());
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public int getSecondLowerBound() {
        return this.secondLowerBound;
    }

    public int getSecondUpperBound() {
        return this.secondUpperBound;
    }

    public int getDefaultSlot() {
        return this.defaultSlot;
    }

    public boolean isNewMusic() {
        return this.newMusic;
    }

    public void setNewMusic(boolean newMusic) {
        this.newMusic = newMusic;
    }

    public boolean isSecondBound() {
        return this.secondBound;
    }

    public static Map<Location, JukeboxCache> getCACHE_MAP() {
        return CACHE_MAP;
    }

    public static class JukeboxCache {
        public boolean isOn;
        public boolean isPlaying;
        public int currentSlot;
        @Nullable
        public ItemStack itemStack;

        public JukeboxCache(boolean isOn, boolean isPlaying, int currentSlot, @Nullable ItemStack itemStack) {
            this.isOn = isOn;
            this.currentSlot = currentSlot;
            this.isPlaying = isPlaying;
            this.itemStack = itemStack;
        }
    }
}

