/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class MainStaff {
    private final List<String> defaultLore;
    private final NamespacedKey storageKey;
    private final String id;

    public MainStaff(List<String> lore, int uses, NamespacedKey storageKey, ItemStack itemStack, String id) {
        this.defaultLore = lore;
        this.storageKey = storageKey;
        this.id = id;
        this.setConfigValues(uses);
        Utils.setLore(itemStack, this.getId(), "-max-uses", "left", "&e", " left");
    }

    public void setConfigValues(int maxUses) throws IOException {
        FNAmplifications.getInstance().getConfigManager().setIntegerValues(this.getId() + "-max-uses", maxUses, "staffs-settings");
    }

    public void updateLore(List<String> lore) {
        for (int i = 0; i < this.getDefaultLore().size(); ++i) {
            lore.add(i, this.getDefaultLore().get(i));
        }
    }

    public void updateMeta(ItemStack item, ItemMeta meta, Player player) {
        PersistentDataContainer max_Uses = meta.getPersistentDataContainer();
        int uses_Left = (Integer)max_Uses.getOrDefault(this.getStorageKey(), PersistentDataType.INTEGER, (Object)FNAmplifications.getInstance().getConfigManager().getValueById(this.getId() + "-max-uses"));
        int decrement = uses_Left - 1;
        ArrayList<String> lore = new ArrayList<String>();
        if (decrement > 0) {
            max_Uses.set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)decrement);
            this.updateLore(lore);
            lore.add("");
            lore.add(Utils.colorTranslator("&eUses: " + decrement + " left"));
            meta.setLore(lore);
            item.setItemMeta(meta);
        } else {
            player.getInventory().setItemInMainHand(null);
            player.sendMessage(Utils.colorTranslator(meta.getDisplayName() + " &d&lhas reached max uses!"));
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        }
    }

    public List<String> getDefaultLore() {
        return this.defaultLore;
    }

    public NamespacedKey getStorageKey() {
        return this.storageKey;
    }

    public String getId() {
        return this.id;
    }
}

