/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.staffs.MainStaff;
import ne.fnfal113.fnamplifications.staffs.abstracts.AbstractStaff;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class StaffOfHellFire
extends AbstractStaff {
    private final NamespacedKey defaultUsageKey = new NamespacedKey((Plugin)FNAmplifications.getInstance(), "hellstaff");
    private final MainStaff mainStaff = new MainStaff(this.lore(), 10, this.getStorageKey(), this.getItem(), this.getId());

    public StaffOfHellFire(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    protected NamespacedKey getStorageKey() {
        return this.defaultUsageKey;
    }

    @Override
    public List<String> lore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(0, "");
        lore.add(1, ChatColor.LIGHT_PURPLE + "Spawn an area of effect cloud");
        lore.add(2, ChatColor.LIGHT_PURPLE + "where entities are set on fire");
        lore.add(3, ChatColor.LIGHT_PURPLE + "if inside the radius for 8 seconds");
        return lore;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        Block block = event.getPlayer().getTargetBlockExact(50);
        if (block == null || item.getType() == Material.AIR) {
            return;
        }
        if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), block, Interaction.BREAK_BLOCK)) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission to cast hellfire there!");
            return;
        }
        ItemMeta meta = item.getItemMeta();
        this.mainStaff.updateMeta(item, meta, player);
        AreaEffectCloud effectCloud = (AreaEffectCloud)player.getWorld().spawnEntity(block.getLocation().add(0.5, 1.0, 0.5), EntityType.AREA_EFFECT_CLOUD);
        effectCloud.setParticle(Particle.SMOKE_NORMAL);
        effectCloud.setDuration(160);
        effectCloud.setRadius(2.85f);
        effectCloud.setCustomName("FN_HELL_FIRE");
        effectCloud.setCustomNameVisible(false);
        effectCloud.addCustomEffect(new PotionEffect(PotionEffectType.GLOWING, 0, 0, false, false, false), true);
        Objects.requireNonNull(player.getLocation().getWorld()).playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 1.0f, 1.0f);
    }
}

