/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.materialgenerators.implementations;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import ne.fnfal113.fnamplifications.ExtraUtils.interfaces.InventoryBlock;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CustomMaterialGenerator
extends SlimefunItem
implements InventoryBlock {
    private static final Map<BlockPosition, Integer> generatorProgress = new HashMap<BlockPosition, Integer>();
    private static final CustomItemStack notGenerating = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cNot Generating", new String[]{"&ePlace a chest above first!"});
    private ItemStack item;
    private String material;

    @ParametersAreNonnullByDefault
    public CustomMaterialGenerator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int tickRate) {
        super(itemGroup, item, recipeType, recipe);
        this.createPreset(this, this.getInventoryTitle(), blockMenuPreset -> {
            for (int i = 0; i < 9; ++i) {
                blockMenuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            blockMenuPreset.addItem(4, (ItemStack)notGenerating);
        });
        try {
            FNAmplifications.getInstance().getConfigManager().setIntegerValues(item.getItemId(), tickRate, "material-gen-tickrate");
            Utils.setLore(this.getItem(), this.getId(), "", "ticks", "&6", " ticks");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            @ParametersAreNonnullByDefault
            public void tick(Block b, SlimefunItem sf, Config data) {
                CustomMaterialGenerator.this.tick(b);
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    public void tick(@Nonnull Block b) {
        Inventory inv;
        BlockState state;
        BlockMenu invMenu = BlockStorage.getInventory((Block)b);
        Block targetBlock = b.getRelative(BlockFace.UP);
        if (invMenu.toInventory() != null && invMenu.hasViewer()) {
            invMenu.replaceExistingItem(4, (ItemStack)notGenerating);
        }
        if (targetBlock.getType() == Material.CHEST && (state = PaperLib.getBlockState((Block)targetBlock, (boolean)false).getState()) instanceof InventoryHolder && (inv = ((InventoryHolder)state).getInventory()).firstEmpty() != -1) {
            BlockPosition pos = new BlockPosition(b);
            int progress = generatorProgress.getOrDefault(pos, 0);
            if (invMenu.toInventory() != null && invMenu.hasViewer()) {
                invMenu.replaceExistingItem(4, (ItemStack)new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, "&aGenerating Material", new String[]{"", "&bMaterial: " + this.material, "&bRate: " + ChatColor.GREEN + FNAmplifications.getInstance().getConfigManager().getValueById(this.getId()) + " &aticks", "", "&2Progress: " + progress + "/" + FNAmplifications.getInstance().getConfigManager().getValueById(this.getId())}));
            }
            if (progress >= FNAmplifications.getInstance().getConfigManager().getValueById(this.getId())) {
                progress = 0;
                inv.addItem(new ItemStack[]{this.item});
            } else {
                ++progress;
            }
            generatorProgress.put(pos, progress);
        }
    }

    @Nonnull
    public String getInventoryTitle() {
        return this.getItemName();
    }

    public final CustomMaterialGenerator setItem(@Nonnull Material material) {
        this.item = new ItemStack(material);
        return this;
    }

    public final CustomMaterialGenerator getMaterialName(String materialName) {
        this.material = materialName;
        return this;
    }

    @Override
    public int[] getInputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }
}

