/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.staffs.MainStaff;
import ne.fnfal113.fnamplifications.staffs.abstracts.AbstractStaff;
import ne.fnfal113.fnamplifications.staffs.implementations.AirStriderTask;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class StaffOfAirStrider
extends AbstractStaff {
    private final NamespacedKey defaultUsageKey;
    private final Map<UUID, BukkitTask> taskMap = new HashMap<UUID, BukkitTask>();
    private final MainStaff mainStaff;

    public StaffOfAirStrider(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.defaultUsageKey = new NamespacedKey((Plugin)FNAmplifications.getInstance(), "airstriderstaff");
        this.mainStaff = new MainStaff(this.lore(), 10, this.getStorageKey(), this.getItem(), this.getId());
    }

    @Nonnull
    protected NamespacedKey getStorageKey() {
        return this.defaultUsageKey;
    }

    @Override
    public List<String> lore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(0, "");
        lore.add(1, ChatColor.LIGHT_PURPLE + "Right click to gain the ability to");
        lore.add(2, ChatColor.LIGHT_PURPLE + "walk on the air for 10 seconds");
        return lore;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (this.taskMap.containsKey(player.getUniqueId())) {
            if (!this.taskMap.get(player.getUniqueId()).isCancelled()) {
                player.sendMessage(Utils.colorTranslator("&6Air strider is not yet expired!"));
            }
            return;
        }
        if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), player.getLocation(), Interaction.PLACE_BLOCK)) {
            player.sendMessage(ChatColor.RED + "You have no permission to cast air strider on this land claim!");
            return;
        }
        player.sendMessage(ChatColor.LIGHT_PURPLE + "You can now walk on the air for 10 seconds");
        this.taskMap.put(player.getUniqueId(), new AirStriderTask(player).runTaskTimer((Plugin)FNAmplifications.getInstance(), 0L, 1L));
        ItemMeta meta = item.getItemMeta();
        this.mainStaff.updateMeta(item, meta, player);
        AtomicInteger i = new AtomicInteger(10);
        Bukkit.getScheduler().runTaskTimer((Plugin)FNAmplifications.getInstance(), task -> {
            if (i.get() <= 5) {
                player.sendMessage(Utils.colorTranslator("&dAir strider will expire in ") + i + " seconds");
            }
            if (i.get() == 0) {
                player.sendMessage(ChatColor.LIGHT_PURPLE + "Air Strider has expired!");
                this.taskMap.get(player.getUniqueId()).cancel();
                this.taskMap.remove(player.getUniqueId());
                task.cancel();
            }
            i.getAndDecrement();
        }, 0L, 23L);
        Objects.requireNonNull(player.getLocation().getWorld()).playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 1.0f, 1.0f);
    }
}

