/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.utils.WorldUtils;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.staffs.MainStaff;
import ne.fnfal113.fnamplifications.staffs.abstracts.AbstractStaff;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class StaffOfMinerals
extends AbstractStaff {
    private final NamespacedKey defaultUsageKey = new NamespacedKey((Plugin)FNAmplifications.getInstance(), "mineralstaff");
    private final MainStaff mainStaff = new MainStaff(this.lore(), 10, this.getStorageKey(), this.getItem(), this.getId());

    public StaffOfMinerals(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    protected NamespacedKey getStorageKey() {
        return this.defaultUsageKey;
    }

    @Override
    public List<String> lore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(0, "");
        lore.add(1, ChatColor.LIGHT_PURPLE + "Right click to receive mythical");
        lore.add(2, ChatColor.LIGHT_PURPLE + "information that awaits upon using");
        lore.add(3, ChatColor.LIGHT_PURPLE + "the staff");
        return lore;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        Chunk chunk = player.getLocation().getChunk();
        Set materials = SlimefunTag.ORES.getValues();
        HashMap<String, Integer> MINERALS = new HashMap<String, Integer>();
        ArrayList contents = new ArrayList();
        ArrayList<String> firstPage = new ArrayList<String>();
        int amount = 0;
        for (int y = WorldUtils.getMinHeight((World)chunk.getWorld()); y <= chunk.getWorld().getMaxHeight(); ++y) {
            for (int x = 0; x <= 15; ++x) {
                for (int z = 0; z <= 15; ++z) {
                    Block itemStack = chunk.getBlock(x, y, z);
                    if (!materials.contains(itemStack.getType())) continue;
                    MINERALS.put(itemStack.getType().name(), MINERALS.getOrDefault(itemStack.getType().name(), 0) + 1);
                    ++amount;
                }
            }
        }
        ItemStack writtenBook = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta bookMeta = (BookMeta)writtenBook.getItemMeta();
        if (bookMeta == null) {
            return;
        }
        bookMeta.setTitle("Mineral Ores");
        bookMeta.setAuthor("FN_FAL113");
        if (amount != 0) {
            MINERALS.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEachOrdered(e -> contents.add(ChatColor.DARK_GREEN + ((Integer)e.getValue()).toString() + "x " + ChatColor.GOLD + StringUtils.capitalize((String)((String)e.getKey()).toLowerCase(Locale.ROOT))));
            firstPage.add(ChatColor.BLUE + "    Staff of Minerals\n\n " + ChatColor.GRAY + "  Through the power of the staff, you are bestowed with magical information written on this book containing the ores from the chunk you are standing at");
            bookMeta.addPage(new String[]{this.firstPageBook(firstPage)});
            for (int i = 0; i < contents.size(); i += 5) {
                bookMeta.addPage(new String[]{contents.subList(i, Math.min(i + 5, contents.size())).toString().replace("[", "").replace("]", "").replace(":", ChatColor.GRAY + " =").replace(", ", "\n\n").replace("_", " ")});
            }
        } else {
            firstPage.add(ChatColor.BLUE + "    Staff of Minerals\n\n " + ChatColor.GRAY + "  There are no ores from your chunk location");
            bookMeta.addPage(new String[]{this.firstPageBook(firstPage)});
        }
        ItemMeta meta = item.getItemMeta();
        this.mainStaff.updateMeta(item, meta, player);
        writtenBook.setItemMeta((ItemMeta)bookMeta);
        player.openBook(writtenBook);
        Objects.requireNonNull(player.getLocation().getWorld()).playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 1.0f, 1.0f);
    }

    public String firstPageBook(List<String> firstPage) {
        return firstPage.toString().replace("[", "").replace("]", "");
    }
}

