/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs.implementations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class AirStriderTask
extends BukkitRunnable {
    private final Map<UUID, List<Block>> blockMap = new HashMap<UUID, List<Block>>();
    private final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();
    private final Player player;

    public AirStriderTask(Player player) {
        this.player = player;
        this.cooldown.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void run() {
        if (this.cooldown.containsKey(this.player.getUniqueId())) {
            long diff = (System.currentTimeMillis() - this.cooldown.get(this.player.getUniqueId())) / 1000L;
            if (diff < 10L) {
                if (this.blockMap.containsKey(this.player.getUniqueId())) {
                    List<Block> block = this.blockMap.get(this.player.getUniqueId());
                    for (Block blocks : block) {
                        if (blocks == null) continue;
                        blocks.setType(Material.AIR);
                    }
                    this.blockMap.remove(this.player.getUniqueId());
                }
                ArrayList<Block> blockList = new ArrayList<Block>();
                for (int x = -3; x <= 3; ++x) {
                    for (int z = -3; z <= 3; ++z) {
                        Block newBlock = this.player.getLocation().getBlock().getRelative(x, -1, z);
                        if (newBlock.getType() != Material.AIR) continue;
                        blockList.add(newBlock);
                        newBlock.setType(Material.BARRIER);
                        this.blockMap.put(this.player.getUniqueId(), blockList);
                    }
                }
            } else {
                List<Block> block = this.blockMap.get(this.player.getUniqueId());
                for (Block blocks : block) {
                    if (blocks == null) continue;
                    blocks.setType(Material.AIR);
                }
                this.cooldown.remove(this.player.getUniqueId());
            }
        }
    }

    public Map<UUID, List<Block>> getBlockMap() {
        return this.blockMap;
    }

    public Map<UUID, Long> getCooldown() {
        return this.cooldown;
    }

    public Player getPlayer() {
        return this.player;
    }
}

