/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gears.implementation;

import com.google.common.base.Strings;
import java.util.List;
import ne.fnfal113.fnamplifications.gems.implementation.WeaponArmorEnum;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class MainGears {
    private final NamespacedKey storageKey;
    private final NamespacedKey storageKey2;
    private final NamespacedKey storageKey3;
    public final List<String> defaultLore;
    private final int startingProgress;
    private final int incrementProgress;
    final ItemStack itemStack;
    private int level;

    public MainGears(NamespacedKey key1, NamespacedKey key2, NamespacedKey key3, List<String> lore, ItemStack item, int startingProgress, int incrementProgress) {
        this.storageKey = key1;
        this.storageKey2 = key2;
        this.storageKey3 = key3;
        this.defaultLore = lore;
        this.itemStack = item;
        this.startingProgress = startingProgress;
        this.incrementProgress = incrementProgress;
    }

    public String getProgressBar(int current, int max, int totalBars, char symbol, ChatColor completedColor, ChatColor notCompletedColor) {
        float percent = (float)current / (float)max;
        int progressBars = (int)((float)totalBars * percent);
        return Strings.repeat((String)("" + completedColor + symbol), (int)progressBars) + Strings.repeat((String)("" + notCompletedColor + symbol), (int)(totalBars - progressBars));
    }

    public void updateLore(List<String> lore) {
        for (int i = 0; i < this.getDefaultLore().size(); ++i) {
            lore.set(i, this.getDefaultLore().get(i));
        }
    }

    public boolean onHit(EntityDamageByEntityEvent event, Player p, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = this.getStorageKey();
        NamespacedKey key2 = this.getStorageKey2();
        NamespacedKey key3 = this.getStorageKey3();
        PersistentDataContainer progress = meta.getPersistentDataContainer();
        PersistentDataContainer level = meta.getPersistentDataContainer();
        PersistentDataContainer max = meta.getPersistentDataContainer();
        int amount = (Integer)progress.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
        int armorLevel = (Integer)level.getOrDefault(key2, PersistentDataType.INTEGER, (Object)0);
        int maxReq = (Integer)max.getOrDefault(key3, PersistentDataType.INTEGER, (Object)this.getStartingProgress());
        int total = amount + 1;
        progress.set(key, PersistentDataType.INTEGER, (Object)total);
        List lore = meta.getLore();
        if (total >= 0) {
            this.updateLore(lore);
            lore.set(7, ChatColor.YELLOW + "Level: " + armorLevel);
            lore.set(8, ChatColor.YELLOW + "Progress:");
            lore.set(9, ChatColor.GRAY + "[" + this.getProgressBar(total, maxReq, 10, '\u25a0', ChatColor.YELLOW, ChatColor.GRAY) + ChatColor.GRAY + "]");
            if (WeaponArmorEnum.CHESTPLATE.isTagged(this.itemStack.getType()) && armorLevel == 30 && total == 1) {
                lore.add(10, "");
                lore.add(11, ChatColor.RED + "\u25ec\u25ec\u25ec\u25ec\u25ec\u25ec| " + ChatColor.LIGHT_PURPLE + "" + ChatColor.BOLD + "Effects " + ChatColor.GOLD + "|\u25ec\u25ec\u25ec\u25ec\u25ec\u25ec");
                lore.add(12, ChatColor.GREEN + "Permanent Saturation");
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        if (total == maxReq) {
            int totalLevel = armorLevel + 1;
            progress.set(key, PersistentDataType.INTEGER, (Object)0);
            level.set(key2, PersistentDataType.INTEGER, (Object)totalLevel);
            this.updateLore(lore);
            lore.set(7, ChatColor.YELLOW + "Level: " + totalLevel);
            lore.set(8, ChatColor.YELLOW + "Progress:");
            lore.set(9, ChatColor.GRAY + "[" + this.getProgressBar(total, maxReq, 10, '\u25a0', ChatColor.YELLOW, ChatColor.GRAY) + ChatColor.GRAY + "]");
            max.set(key3, PersistentDataType.INTEGER, (Object)(maxReq + this.getIncrementProgress()));
            meta.setLore(lore);
            item.setItemMeta(meta);
            this.levelUp(p);
            this.setLevel(totalLevel);
            return true;
        }
        return false;
    }

    public void levelUp(Player p) {
        p.sendMessage(Utils.colorTranslator("&c&l[FNAmpli&b&lfications]> " + this.getItemStack().getItemMeta().getDisplayName() + " leveled up!"));
        p.playSound(p.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
    }

    public NamespacedKey getStorageKey() {
        return this.storageKey;
    }

    public NamespacedKey getStorageKey2() {
        return this.storageKey2;
    }

    public NamespacedKey getStorageKey3() {
        return this.storageKey3;
    }

    public List<String> getDefaultLore() {
        return this.defaultLore;
    }

    public int getStartingProgress() {
        return this.startingProgress;
    }

    public int getIncrementProgress() {
        return this.incrementProgress;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

