/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.quivers.implementations;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.quivers.Quiver;
import ne.fnfal113.fnamplifications.quivers.SpectralQuiver;
import ne.fnfal113.fnamplifications.quivers.UpgradedQuiver;
import ne.fnfal113.fnamplifications.quivers.UpgradedSpectralQuiver;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class MainQuiver {
    private final NamespacedKey storageKey;
    private final NamespacedKey storageKey2;
    private final NamespacedKey storageKey3;
    private final int quiverSize;
    private final ItemStack arrowType;
    private final SlimefunItemStack sfItemStack;
    private final List<String> defaultLore;

    public MainQuiver(NamespacedKey key1, NamespacedKey key2, NamespacedKey key3, int quiverSize, ItemStack arrow, SlimefunItemStack slimefunItemStack, List<String> lore) {
        this.storageKey = key1;
        this.storageKey2 = key2;
        this.storageKey3 = key3;
        this.quiverSize = quiverSize;
        this.arrowType = arrow;
        this.sfItemStack = slimefunItemStack;
        this.defaultLore = lore;
    }

    public void updateLore(List<String> lore) {
        for (int i = 0; i < 7; ++i) {
            lore.add(i, this.getDefaultLore().get(i));
        }
    }

    public SlimefunItem getSfItem(ItemStack itemStack) {
        return SlimefunItem.getByItem((ItemStack)itemStack);
    }

    public int getArrows(PersistentDataContainer arrowPdc, NamespacedKey key) {
        return (Integer)arrowPdc.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
    }

    public boolean isQuiver(SlimefunItem item) {
        if (item instanceof Quiver) {
            return true;
        }
        if (item instanceof UpgradedQuiver) {
            return true;
        }
        if (item instanceof SpectralQuiver) {
            return true;
        }
        return item instanceof UpgradedSpectralQuiver;
    }

    public void changeState(ItemStack itemState, ItemMeta arrowMeta, PersistentDataContainer arrowsCheck) {
        boolean pdcCheck;
        int arrowsCheckPDC = this.getArrows(arrowsCheck, this.getStorageKey());
        boolean bl = pdcCheck = arrowsCheckPDC == 0;
        if (pdcCheck) {
            return;
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (itemState.getType() == Material.LEATHER) {
            arrowMeta.getPersistentDataContainer().set(this.getStorageKey3(), PersistentDataType.STRING, (Object)"opened");
            itemState.setType(this.getArrowType().getType());
            this.updateLore(lore);
            lore.add(7, ChatColor.YELLOW + "Arrows: " + ChatColor.WHITE + arrowsCheckPDC);
            lore.add(8, ChatColor.YELLOW + "State: Open Quiver");
        } else {
            arrowMeta.getPersistentDataContainer().set(this.getStorageKey3(), PersistentDataType.STRING, (Object)"closed");
            itemState.setType(Material.LEATHER);
            this.updateLore(lore);
            lore.add(7, ChatColor.YELLOW + "Arrows: " + ChatColor.WHITE + arrowsCheckPDC);
            lore.add(8, ChatColor.YELLOW + "State: Closed Quiver");
        }
        arrowMeta.setLore(lore);
        itemState.setItemMeta(arrowMeta);
    }

    public void withdrawArrows(ItemStack itemState, ItemMeta meta, Player player, PersistentDataContainer arrowsCheck) {
        boolean pdcCheck;
        int arrowsCheckPDC = this.getArrows(arrowsCheck, this.getStorageKey());
        boolean bl = pdcCheck = arrowsCheckPDC == 0;
        if (pdcCheck) {
            return;
        }
        int amount = arrowsCheckPDC - 1;
        meta.getPersistentDataContainer().set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)amount);
        ArrayList<String> itemLore = new ArrayList<String>();
        this.updateLore(itemLore);
        itemLore.add(7, ChatColor.YELLOW + "Arrows: " + ChatColor.WHITE + amount);
        if (amount == 0) {
            if (meta.getPersistentDataContainer().has(this.getStorageKey3(), PersistentDataType.STRING)) {
                meta.getPersistentDataContainer().remove(this.getStorageKey3());
            }
            itemLore.add(8, ChatColor.YELLOW + "State: Closed Quiver (Empty)");
            itemState.setType(Material.LEATHER);
            player.sendMessage(ChatColor.GOLD + this.getSfItemStack().getDisplayName() + " is now empty");
        } else if (itemState.getType() == Material.SPECTRAL_ARROW) {
            itemLore.add(8, ChatColor.YELLOW + "State: Open Quiver");
        } else {
            itemLore.add(8, ChatColor.YELLOW + "State: Closed Quiver");
        }
        meta.setLore(itemLore);
        itemState.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{this.getArrowType().clone()});
    }

    public void depositArrows(ItemStack item, ItemMeta meta, PersistentDataContainer arrowsCheck, Player player) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        boolean isNormalItem = this.isQuiver(this.getSfItem(itemStack));
        int arrowsCheckPDC = this.getArrows(arrowsCheck, this.getStorageKey());
        if (itemStack.getType() != this.getArrowType().getType()) {
            return;
        }
        if (isNormalItem) {
            return;
        }
        if (item.getAmount() != 1) {
            player.sendMessage(Utils.colorTranslator("&eUnstack the quivers first before using them"));
            return;
        }
        int increment = arrowsCheckPDC + 1;
        ArrayList<String> lore = new ArrayList<String>();
        if (increment != this.getQuiverSize() + 1) {
            meta.getPersistentDataContainer().set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)increment);
            this.updateLore(lore);
            lore.add(7, ChatColor.YELLOW + "Arrows: " + ChatColor.WHITE + increment);
            lore.add(8, ChatColor.YELLOW + "State: Open Quiver");
            meta.setLore(lore);
            if (increment <= 2) {
                int random = ThreadLocalRandom.current().nextInt(1, 1000000);
                meta.getPersistentDataContainer().set(this.getStorageKey2(), PersistentDataType.INTEGER, (Object)random);
            }
            item.setItemMeta(meta);
            item.setType(this.getArrowType().getType());
            itemStack.setAmount(itemStack.getAmount() - 1);
            if (increment == this.getQuiverSize()) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.getSfItemStack().getDisplayName() + " is full!")));
            }
        }
    }

    public void bowShoot(EntityShootBowEvent event, ItemStack itemStack, boolean checkInfinity) {
        if (itemStack == null) {
            return;
        }
        Player player = (Player)event.getEntity();
        event.setConsumeItem(false);
        player.updateInventory();
        ItemMeta meta = itemStack.getItemMeta();
        ItemMeta bowMeta = player.getInventory().getItemInMainHand().getItemMeta();
        if (meta == null || bowMeta == null) {
            return;
        }
        PersistentDataContainer arrow_Left = meta.getPersistentDataContainer();
        int arrows = this.getArrows(arrow_Left, this.getStorageKey());
        int decrement = arrows - 1;
        if (checkInfinity && bowMeta.hasEnchant(Enchantment.ARROW_INFINITE)) {
            decrement = arrows;
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (decrement >= 0) {
            arrow_Left.set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)decrement);
            this.updateLore(lore);
            lore.add(7, ChatColor.YELLOW + "Arrows: " + ChatColor.WHITE + decrement);
            lore.add(8, ChatColor.YELLOW + "State: Open Quiver");
            if (decrement == 0) {
                if (arrow_Left.has(this.getStorageKey3(), PersistentDataType.STRING)) {
                    meta.getPersistentDataContainer().remove(this.getStorageKey3());
                }
                itemStack.setType(Material.LEATHER);
                lore.set(8, ChatColor.YELLOW + "State: Closed Quiver (Empty)");
            }
            meta.setLore(lore);
            itemStack.setItemMeta(meta);
        }
    }

    public NamespacedKey getStorageKey() {
        return this.storageKey;
    }

    public NamespacedKey getStorageKey2() {
        return this.storageKey2;
    }

    public NamespacedKey getStorageKey3() {
        return this.storageKey3;
    }

    public int getQuiverSize() {
        return this.quiverSize;
    }

    public ItemStack getArrowType() {
        return this.arrowType;
    }

    public SlimefunItemStack getSfItemStack() {
        return this.sfItemStack;
    }

    public List<String> getDefaultLore() {
        return this.defaultLore;
    }
}

