/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import ne.fnfal113.fnamplifications.machines.implementation.DiscDurationsEnum;
import ne.fnfal113.fnamplifications.machines.implementation.JukeBox;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.Jukebox;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ElectricJukebox
extends JukeBox {
    private final Map<Location, Integer> durationMap = new HashMap<Location, Integer>();

    @ParametersAreNonnullByDefault
    public ElectricJukebox(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int lowerBound, int upperBound, int defaultSlot, int secondLowerBound, int secondUpperBound, boolean hasSecondBound) {
        super(itemGroup, item, recipeType, recipe, lowerBound, upperBound, defaultSlot, secondLowerBound, secondUpperBound, hasSecondBound);
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            public void tick(Block block, SlimefunItem slimefunItem, Config data) {
                ElectricJukebox.this.onTick(block);
            }
        }, new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent event) {
                BlockStorage.addBlockInfo((Block)event.getBlock(), (String)"owner", (String)event.getPlayer().getUniqueId().toString());
            }
        }, new BlockBreakHandler(false, false){

            public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
                BlockMenu menu = BlockStorage.getInventory((Block)e.getBlock());
                if (menu != null) {
                    int upperBound = ElectricJukebox.this.getSecondUpperBound() > 0 ? ElectricJukebox.this.getSecondUpperBound() : ElectricJukebox.this.getUpperBound();
                    for (int i = ElectricJukebox.this.getLowerBound(); i < upperBound + 1; ++i) {
                        if (menu.getItemInSlot(i) == null) continue;
                        ItemStack itemStack = menu.getItemInSlot(i);
                        ItemMeta meta = itemStack.getItemMeta();
                        if (meta.hasEnchant(Enchantment.BINDING_CURSE)) {
                            meta.removeEnchant(Enchantment.BINDING_CURSE);
                            itemStack.setItemMeta(meta);
                        }
                        if (itemStack.getType() == Material.PINK_STAINED_GLASS_PANE || itemStack.getType() == Material.GRAY_STAINED_GLASS_PANE) continue;
                        menu.dropItems(menu.getLocation(), new int[]{i});
                    }
                }
            }
        }});
        this.createPreset(this, this.getItemName(), blockMenuPreset -> {
            this.addGuiItems((BlockMenuPreset)blockMenuPreset);
            blockMenuPreset.addItem(5, (ItemStack)this.NO_POWER);
        });
    }

    public void addGuiItems(BlockMenuPreset menuPreset) {
        int i;
        for (i = 0; i < 9; ++i) {
            menuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (i = 45; i < 54; ++i) {
            menuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (i = 9; i < 45; ++i) {
            if (i < this.getLowerBound()) {
                menuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            if (this.getSecondLowerBound() > 0 && this.getSecondUpperBound() > 0) {
                if (i < this.getSecondLowerBound() && i > this.getUpperBound()) {
                    menuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
                }
                if (i <= this.getSecondUpperBound()) continue;
                menuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
                continue;
            }
            if (i <= this.getUpperBound()) continue;
            menuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                ElectricJukebox.this.addGuiItems(this);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return ElectricJukebox.this.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[]{0};
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                String isRunning = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"toggled_On");
                String currentSlot = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"current_Slot");
                String isPlaying = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"is_Playing");
                boolean isOn = false;
                if (isRunning != null) {
                    isOn = Boolean.parseBoolean(isRunning);
                }
                menu.replaceExistingItem(50, (ItemStack)(isOn ? ElectricJukebox.this.TOGGLED_ON : ElectricJukebox.this.TOGGLED_OFF));
                menu.addMenuClickHandler(50, (p, slot, item, action) -> {
                    ElectricJukebox.this.toggleOnOrOff(menu);
                    return false;
                });
                int discSlot = ElectricJukebox.this.getDefaultSlot();
                if (currentSlot != null) {
                    discSlot = Integer.parseInt(currentSlot);
                }
                menu.replaceExistingItem(0, (ItemStack)ElectricJukebox.this.PREVIOUS);
                menu.addMenuClickHandler(0, (p, slot, item, action) -> {
                    ElectricJukebox.this.previousSlot(p, menu, false);
                    return false;
                });
                menu.replaceExistingItem(8, (ItemStack)ElectricJukebox.this.NEXT);
                menu.addMenuClickHandler(8, (p, slot, item, action) -> {
                    ElectricJukebox.this.nextSlot(p, menu);
                    return false;
                });
                boolean playing = false;
                if (isPlaying != null) {
                    playing = Boolean.parseBoolean(isPlaying);
                }
                menu.replaceExistingItem(4, (ItemStack)(playing ? ElectricJukebox.this.PLAY : ElectricJukebox.this.STOP));
                menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                    ElectricJukebox.this.playSlot(p, menu);
                    return false;
                });
                JukeBox.JukeboxCache cache = new JukeBox.JukeboxCache(isOn, playing, discSlot, null);
                JukeBox.getCACHE_MAP().put(menu.getLocation(), cache);
            }
        };
    }

    public void onTick(@Nonnull Block b) {
        BlockMenu invMenu = BlockStorage.getInventory((Block)b);
        if (!(b.getBlockData() instanceof org.bukkit.block.data.type.Jukebox)) {
            return;
        }
        Jukebox jukebox = (Jukebox)invMenu.getBlock().getState();
        JukeBox.JukeboxCache cache = ElectricJukebox.getCACHE_MAP().get(b.getLocation());
        if (this.getCharge(b.getLocation()) > 0) {
            if (invMenu.hasViewer()) {
                invMenu.replaceExistingItem(48, (ItemStack)this.NOT_RUNNING);
            }
            if (cache.isOn) {
                if (cache.isPlaying) {
                    int currentTime = this.durationMap.getOrDefault(b.getLocation(), 0);
                    if (this.isNewMusic()) {
                        this.durationMap.put(b.getLocation(), 0);
                        this.setNewMusic(false);
                        return;
                    }
                    if (invMenu.hasViewer()) {
                        invMenu.replaceExistingItem(48, (ItemStack)this.OPERATING);
                        if (jukebox.getPlaying() != Material.AIR) {
                            invMenu.replaceExistingItem(49, (ItemStack)new CustomItemStack(Material.PINK_STAINED_GLASS_PANE, "&d&lPlaying: " + jukebox.getPlaying().toString().replace("_", " "), new String[]{"&eDuration : " + this.durationMap.get(b.getLocation()) + "/" + DiscDurationsEnum.valueOf(jukebox.getPlaying().toString().toUpperCase()).getDurationInSec() * 2}));
                        }
                    }
                    if (this.durationMap.containsKey(b.getLocation())) {
                        if (this.durationMap.get(b.getLocation()) >= DiscDurationsEnum.valueOf(jukebox.getPlaying().toString().toUpperCase()).getDurationInSec() * 2) {
                            this.nextSlot(null, invMenu);
                            currentTime = 0;
                        } else if (++currentTime == 1) {
                            jukebox.update(true);
                        }
                    }
                    this.durationMap.put(b.getLocation(), currentTime);
                    Objects.requireNonNull(jukebox.getLocation().getWorld()).spawnParticle(Particle.NOTE, b.getLocation().add(0.0, 0.8, 0.0), 2);
                } else {
                    this.durationMap.put(b.getLocation(), 0);
                    if (invMenu.hasViewer()) {
                        invMenu.replaceExistingItem(48, (ItemStack)this.NOT_OPERATING);
                        this.changeStatus(invMenu, cache.currentSlot);
                    }
                }
                this.takeCharge(b.getLocation());
            } else if (cache.isPlaying) {
                this.stopJukebox(jukebox, invMenu.getLocation(), cache, invMenu);
                this.durationMap.put(b.getLocation(), 0);
                if (invMenu.hasViewer()) {
                    this.changeStatus(invMenu, cache.currentSlot);
                }
            }
        }
    }
}

