/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems.implementation;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.gems.implementation.ReturnWeaponTask;
import ne.fnfal113.fnamplifications.gems.implementation.WeaponArmorEnum;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Tag;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class ThrowWeaponTask
extends BukkitRunnable {
    private final ArmorStand armorStand;
    private final Player player;
    private final ItemStack itemStack;
    private final boolean rotateWeapon;
    private final boolean isCutThrough;
    private final boolean isTriWeapon;
    private final boolean returnWeapon;
    private final Vector vector;
    private final ReturnWeaponTask returnWeaponTask;

    public ThrowWeaponTask(ArmorStand armorStand, Player player, ItemStack itemStack, boolean rotateWeapon, boolean isCutThrough, boolean isTriWeapon, boolean returnWeapon, Vector vector) {
        this.armorStand = armorStand;
        this.player = player;
        this.itemStack = itemStack;
        this.rotateWeapon = rotateWeapon;
        this.isCutThrough = isCutThrough;
        this.isTriWeapon = isTriWeapon;
        this.returnWeapon = returnWeapon;
        this.vector = vector;
        this.returnWeaponTask = new ReturnWeaponTask(itemStack, armorStand, player);
    }

    public void run() {
        this.getArmorStand().teleport(this.getArmorStand().getLocation().add(this.getVector()));
        this.getArmorStand().getWorld().spawnParticle(Particle.DRIPPING_OBSIDIAN_TEAR, this.getArmorStand().getLocation().add(0.0, 0.0, 0.5), 2);
        if (this.isRotateWeapon()) {
            this.getArmorStand().setRightArmPose(Utils.setRightArmAngle(this.getArmorStand(), 45, 0, 0));
        }
        RayTraceResult result = this.getArmorStand().rayTraceBlocks(0.107);
        List entityList = this.getArmorStand().getNearbyEntities(0.3, 0.3, 0.3);
        if (result != null && Objects.requireNonNull(result.getHitBlock()).getType() != Material.GRASS && !Tag.FLOWERS.isTagged((Keyed)result.getHitBlock().getType())) {
            if (this.isReturnWeapon()) {
                this.returnWeapon();
                return;
            }
            this.getPlayer().sendMessage(this.weaponTask(this.getArmorStand(), this.getPlayer(), this.getItemStack().clone()));
            return;
        }
        if (!entityList.isEmpty() && !entityList.contains(this.getPlayer())) {
            for (int i = 0; i < entityList.size(); ++i) {
                if (!(entityList.get(i) instanceof Damageable) || ((Entity)entityList.get(i)).getUniqueId() == this.getPlayer().getUniqueId() || !Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)this.getPlayer().getUniqueId()), ((Entity)entityList.get(i)).getLocation(), Interaction.BREAK_BLOCK)) continue;
                if (WeaponArmorEnum.SWORDS.isTagged(this.getItemStack().clone().getType())) {
                    ((Damageable)entityList.get(i)).damage(ThreadLocalRandom.current().nextInt(100) < 35 ? 8.0 : 5.0);
                    continue;
                }
                ((Damageable)entityList.get(i)).damage(ThreadLocalRandom.current().nextInt(100) < 35 ? 10.0 : 6.0);
            }
            if (this.isReturnWeapon() && !this.isTriWeapon()) {
                this.returnWeapon();
                return;
            }
            if (!this.isTriWeapon()) {
                this.weaponTask(this.getArmorStand(), this.getPlayer(), this.getItemStack().clone());
                return;
            }
        }
        if (this.getArmorStand().getLocation().distanceSquared(this.player.getLocation()) > 3600.0) {
            this.getPlayer().sendMessage(Utils.colorTranslator("&eYour weapon has reached the max distance, " + this.weaponTask(this.getArmorStand(), this.getPlayer(), this.getItemStack().clone())));
        }
    }

    public String weaponTask(ArmorStand as, Player player, ItemStack itemStack) {
        Item droppedItem = as.getWorld().dropItem(as.getLocation(), itemStack.clone());
        Location locInfo = droppedItem.getLocation();
        droppedItem.setOwner(player.getUniqueId());
        droppedItem.setGlowing(true);
        as.remove();
        this.cancel();
        return Utils.colorTranslator("&eWeapon dropped near at x: " + (int)locInfo.getX() + ", y: " + (int)locInfo.getY() + ", z: " + (int)locInfo.getZ());
    }

    public void returnWeapon() {
        this.cancel();
        this.returnWeaponTask.runTaskTimer((Plugin)FNAmplifications.getInstance(), 4L, 1L);
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean isRotateWeapon() {
        return this.rotateWeapon;
    }

    public boolean isCutThrough() {
        return this.isCutThrough;
    }

    public boolean isTriWeapon() {
        return this.isTriWeapon;
    }

    public boolean isReturnWeapon() {
        return this.returnWeapon;
    }

    public Vector getVector() {
        return this.vector;
    }
}

