/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ne.fnfal113.fnamplifications.FNAmplifications;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private File customConfigFile;
    private FileConfiguration customConfig;
    private final Map<String, Integer> integerValues = new HashMap<String, Integer>();
    private final Map<String, Boolean> booleanValues = new HashMap<String, Boolean>();

    public void setBooleanValues(String id, boolean bool, String fileName) throws IOException {
        if (this.createCustomConfig(fileName)) {
            if (!this.getCustomConfig().contains(id)) {
                this.getCustomConfig().set(id, (Object)bool);
            }
            this.getCustomConfig().save(this.customConfigFile);
            boolean value = this.getCustomConfig().getBoolean(id, false);
            this.booleanValues.put(id, value);
        }
    }

    public void setIntegerValues(String id, Integer val, String fileName) throws IOException {
        if (this.createCustomConfig(fileName)) {
            if (!this.getCustomConfig().contains(id)) {
                this.getCustomConfig().set(id, (Object)val);
            }
            this.getCustomConfig().save(this.customConfigFile);
            int value = this.getCustomConfig().getInt(id, 0);
            this.integerValues.put(id, value);
        }
    }

    private boolean createCustomConfig(String fileName) {
        this.customConfigFile = new File(FNAmplifications.getInstance().getDataFolder(), fileName + ".yml");
        if (!this.customConfigFile.exists()) {
            this.customConfigFile.getParentFile().mkdirs();
            FNAmplifications.getInstance().saveResource(fileName + ".yml", false);
        }
        this.customConfig = new YamlConfiguration();
        try {
            this.customConfig.load(this.customConfigFile);
            return true;
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            return false;
        }
    }

    public FileConfiguration getCustomConfig() {
        return this.customConfig;
    }

    public int getValueById(String id) {
        return this.getIntegerValues().get(id);
    }

    public boolean getBoolById(String id) {
        return this.getBooleanValues().get(id);
    }

    public Map<String, Integer> getIntegerValues() {
        return this.integerValues;
    }

    public Map<String, Boolean> getBooleanValues() {
        return this.booleanValues;
    }
}

