/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.staffs.MainStaff;
import ne.fnfal113.fnamplifications.staffs.abstracts.AbstractStaff;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class StaffOfInvisibility
extends AbstractStaff {
    private final NamespacedKey defaultUsageKey = new NamespacedKey((Plugin)FNAmplifications.getInstance(), "invistaff");
    private final MainStaff mainStaff = new MainStaff(this.lore(), 10, this.getStorageKey(), this.getItem(), this.getId());

    public StaffOfInvisibility(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    protected NamespacedKey getStorageKey() {
        return this.defaultUsageKey;
    }

    @Override
    public List<String> lore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(0, "");
        lore.add(1, ChatColor.LIGHT_PURPLE + "6 seconds of invisibility");
        lore.add(2, ChatColor.LIGHT_PURPLE + "even your armor and name are hidden");
        return lore;
    }

    @Override
    public void onRightClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (player.isInvisible()) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cYour invisibility is still active!"));
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        ItemMeta meta = item.getItemMeta();
        this.mainStaff.updateMeta(item, meta, player);
        for (Player online : Bukkit.getOnlinePlayers()) {
            online.hidePlayer((Plugin)FNAmplifications.getInstance(), player);
        }
        PotionEffect effect = new PotionEffect(PotionEffectType.GLOWING, 115, 1, false, false);
        PotionEffect effect2 = new PotionEffect(PotionEffectType.INVISIBILITY, 115, 1, false, false);
        player.addPotionEffect(effect);
        player.addPotionEffect(effect2);
        player.sendMessage(ChatColor.GREEN + "You are now invisible to all players!");
        Objects.requireNonNull(player.getLocation().getWorld()).playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 1.0f, 1.0f);
        Bukkit.getScheduler().runTaskLater((Plugin)FNAmplifications.getInstance(), () -> {
            if (!player.isOnline()) {
                return;
            }
            for (Player online : Bukkit.getOnlinePlayers()) {
                online.showPlayer((Plugin)FNAmplifications.getInstance(), player);
            }
        }, 120L);
    }
}

