/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.mysteriousitems;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.items.FNAmpItems;
import ne.fnfal113.fnamplifications.multiblocks.FnMysteryStickAltar;
import ne.fnfal113.fnamplifications.mysteriousitems.abstracts.AbstractStick;
import ne.fnfal113.fnamplifications.mysteriousitems.implementation.MainStick;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MysteryStick11
extends AbstractStick {
    private static final SlimefunAddon plugin = FNAmplifications.getInstance();
    public final MainStick mainStick = new MainStick(Keys.STICK_11_EXP_LEVELS, Keys.STICK_11_DAMAGE, this.enchantments(), this.weaponLore(), this.stickLore(), 4, 25);

    @ParametersAreNonnullByDefault
    public MysteryStick11(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    public Map<Enchantment, Integer> enchantments() {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        enchantments.put(Enchantment.DAMAGE_ARTHROPODS, 10);
        enchantments.put(Enchantment.DAMAGE_ALL, 8);
        enchantments.put(Enchantment.DAMAGE_UNDEAD, 8);
        enchantments.put(Enchantment.KNOCKBACK, 5);
        return enchantments;
    }

    @Override
    public String weaponLore() {
        return ChatColor.GOLD + "Behind your enemies awaits danger";
    }

    @Override
    public String stickLore() {
        return ChatColor.WHITE + "The stick of the nords";
    }

    @Override
    public void interact(PlayerInteractEvent e) {
        this.mainStick.onInteract(e, Material.DIAMOND_AXE);
    }

    @Override
    public void onSwing(EntityDamageByEntityEvent event) {
        Player player = (Player)event.getDamager();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.DIAMOND_AXE) {
            return;
        }
        if (this.mainStick.onSwing(item, FNAmpItems.FN_STICK_11, player, event.getDamage(), 13, 4)) {
            LivingEntity victim = (LivingEntity)event.getEntity();
            victim.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, 3, false, true, false));
            victim.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 80, 3, false, true, false));
            victim.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 100, 2, false, true, false));
            Location loc = victim.getLocation();
            loc.setYaw(loc.getYaw() + 180.0f);
            victim.teleport(loc);
            victim.sendMessage(ChatColor.DARK_RED + "You have been disoriented! your opponent's mysterious stick is deadly");
            player.sendMessage(Utils.colorTranslator("&cMystery effects was applied to your enemy"));
        }
    }

    public static void setup() {
        new MysteryStick11((ItemGroup)FNAmpItems.MYSTERY_STICKS, FNAmpItems.FN_STICK_11, FnMysteryStickAltar.RECIPE_TYPE, new ItemStack[]{FNAmpItems.FN_STICK_2, new SlimefunItemStack(SlimefunItems.ESSENCE_OF_AFTERLIFE, 1), FNAmpItems.FN_STICK_8, new SlimefunItemStack(SlimefunItems.ESSENCE_OF_AFTERLIFE, 1), FNAmpItems.FN_STICK_5, new SlimefunItemStack(SlimefunItems.ESSENCE_OF_AFTERLIFE, 1), new SlimefunItemStack(SlimefunItems.EARTH_RUNE, 4), new SlimefunItemStack(SlimefunItems.ESSENCE_OF_AFTERLIFE, 2), new SlimefunItemStack(SlimefunItems.AIR_RUNE, 4)}).register(plugin);
    }
}

