/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import javax.annotation.Nonnull;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.items.FNAmpItems;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FnAssemblyStation
extends MultiBlockMachine {
    public static final RecipeType RECIPE_TYPE = new RecipeType(new NamespacedKey((Plugin)FNAmplifications.getInstance(), "fn_assembly_station"), FNAmpItems.FN_ASSEMBLY_STATION, new String[]{"", "&fThis is where you craft some FN stuffs!"});

    public FnAssemblyStation() {
        super((ItemGroup)FNAmpItems.MULTIBLOCK, FNAmpItems.FN_ASSEMBLY_STATION, new ItemStack[]{null, null, null, null, new ItemStack(Material.NETHER_BRICK_FENCE), null, new ItemStack(Material.CRAFTING_TABLE), new ItemStack(Material.DISPENSER), new ItemStack(Material.CRAFTING_TABLE)}, BlockFace.SELF);
    }

    public void onInteract(Player p, Block b) {
        Block dispBlock = b.getRelative(BlockFace.DOWN);
        BlockState state = PaperLib.getBlockState((Block)dispBlock, (boolean)false).getState();
        if (state instanceof Dispenser) {
            Dispenser disp = (Dispenser)state;
            Inventory inv = disp.getInventory();
            List inputs = RecipeType.getRecipeInputList((MultiBlockMachine)this);
            for (int i = 0; i < inputs.size(); ++i) {
                if (!this.canCraft(inv, (ItemStack[])inputs.get(i))) continue;
                ItemStack output = RecipeType.getRecipeOutputList((MultiBlockMachine)this, (ItemStack[])((ItemStack[])inputs.get(i))).clone();
                if (SlimefunUtils.canPlayerUseItem((Player)p, (ItemStack)output, (boolean)true)) {
                    this.craft(dispBlock, p, b, inv, (ItemStack[])inputs.get(i), output);
                }
                return;
            }
            if (SlimefunUtils.isInventoryEmpty((Inventory)inv)) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.inventory-empty", true);
            } else {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
            }
        }
    }

    private boolean canCraft(Inventory inv, ItemStack[] recipe) {
        for (int j = 0; j < inv.getContents().length; ++j) {
            if (SlimefunUtils.isItemSimilar((ItemStack)inv.getContents()[j], (ItemStack)recipe[j], (boolean)true)) continue;
            return false;
        }
        return true;
    }

    protected void craft(Block dispenser, Player p, Block b, Inventory inv, ItemStack[] recipe, ItemStack output) {
        Inventory fakeInv = this.createVirtualInventory(inv);
        Inventory outputInv = this.findOutputInventory(output, dispenser, inv, fakeInv);
        if (outputInv != null) {
            this.craftItem(inv, recipe, p, b);
            outputInv.addItem(new ItemStack[]{output});
        } else {
            this.craftItem(inv, recipe, p, b);
            dispenser.getWorld().dropItem(b.getLocation(), output);
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
            p.sendMessage(Utils.colorTranslator("&dCrafted item has been dropped instead"));
        }
    }

    public void craftItem(Inventory inv, ItemStack[] recipe, Player p, Block b) {
        for (int j = 0; j < 9; ++j) {
            ItemStack item = inv.getContents()[j];
            if (item == null || item.getType() == Material.AIR || !SlimefunUtils.isItemSimilar((ItemStack)inv.getContents()[j], (ItemStack)recipe[j], (boolean)true)) continue;
            ItemUtils.consumeItem((ItemStack)item, (int)recipe[j].getAmount(), (boolean)true);
        }
        p.getWorld().playSound(p.getLocation(), Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f);
        p.getWorld().playEffect(b.getLocation(), Effect.SMOKE, 1);
    }

    @Nonnull
    protected Inventory createVirtualInventory(@Nonnull Inventory inv) {
        Inventory fakeInv = Bukkit.createInventory(null, (int)9, (String)"Fake Inventory");
        for (int j = 0; j < inv.getContents().length; ++j) {
            ItemStack stack = inv.getContents()[j];
            if (stack != null) {
                stack = stack.clone();
                ItemUtils.consumeItem((ItemStack)stack, (boolean)true);
            }
            fakeInv.setItem(j, stack);
        }
        return fakeInv;
    }
}

