/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.handlers.OnDamageHandler;
import ne.fnfal113.fnamplifications.gems.implementation.Gem;
import ne.fnfal113.fnamplifications.gems.implementation.WeaponArmorEnum;
import ne.fnfal113.fnamplifications.items.FNAmpItems;
import ne.fnfal113.fnamplifications.multiblocks.FnGemAltar;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ImpostorGem
extends AbstractGem
implements OnDamageHandler {
    private static final SlimefunAddon plugin = FNAmplifications.getInstance();
    private final int chance = FNAmplifications.getInstance().getConfigManager().getValueById(this.getId() + "-percent-chance");

    public ImpostorGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 14);
    }

    @Override
    public void onDrag(InventoryClickEvent event, Player player) {
        if (event.getCursor() == null) {
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)event.getCursor());
        if (slimefunItem != null && currentItem != null) {
            if (WeaponArmorEnum.HELMET.isTagged(currentItem.getType())) {
                new Gem(slimefunItem, currentItem, player).onDrag(event, false);
            } else {
                player.sendMessage(Utils.colorTranslator("&eInvalid item to socket! Gem works on helmets only"));
            }
        }
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Player) {
            Player victim = (Player)event.getEntity();
            Player damager = (Player)event.getDamager();
            if (ThreadLocalRandom.current().nextInt(100) < this.getChance() && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                float nang = victim.getLocation().getYaw() + 90.0f;
                if (nang < 0.0f) {
                    nang += 360.0f;
                }
                double nX = Math.cos(Math.toRadians(nang));
                double nZ = Math.sin(Math.toRadians(nang));
                Location newDamagerLoc = new Location(victim.getWorld(), damager.getLocation().getX() - nX, damager.getLocation().getY(), damager.getLocation().getZ() - nZ, damager.getLocation().getYaw(), damager.getLocation().getPitch());
                victim.teleport(newDamagerLoc);
            }
        }
    }

    public static void setup() {
        new ImpostorGem((ItemGroup)FNAmpItems.FN_GEMS, FNAmpItems.FN_GEM_IMPOSTOR, FnGemAltar.RECIPE_TYPE, new ItemStack[]{new SlimefunItemStack(SlimefunItems.EARTH_RUNE, 4), new SlimefunItemStack(SlimefunItems.COMMON_TALISMAN, 1), new SlimefunItemStack(SlimefunItems.LIGHTNING_RUNE, 4), new SlimefunItemStack(SlimefunItems.ESSENCE_OF_AFTERLIFE, 1), new ItemStack(Material.EMERALD), new SlimefunItemStack(SlimefunItems.ESSENCE_OF_AFTERLIFE, 1), new SlimefunItemStack(SlimefunItems.AIR_RUNE, 4), new SlimefunItemStack(SlimefunItems.COMMON_TALISMAN, 1), SlimefunItems.WATER_RUNE}).register(plugin);
    }

    public int getChance() {
        return this.chance;
    }
}

