/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.Gems.Listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Objects;
import java.util.UUID;
import ne.fnfal113.fnamplifications.Gems.Abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.Gems.Implementation.TargetReasonEnum;
import ne.fnfal113.fnamplifications.Gems.Interface.OnArrowHitHandler;
import ne.fnfal113.fnamplifications.Gems.Interface.OnBlockBreakHandler;
import ne.fnfal113.fnamplifications.Gems.Interface.OnDamageHandler;
import ne.fnfal113.fnamplifications.Gems.Interface.OnRightClickHandler;
import ne.fnfal113.fnamplifications.Utils.Keys;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Container;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class GemListener
implements Listener {
    @EventHandler
    public void onDragDrop(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.getAction() != InventoryAction.SWAP_WITH_CURSOR) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)event.getCursor());
        if (slimefunItem instanceof AbstractGem) {
            ((AbstractGem)slimefunItem).onDrag(event, player);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Player player;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (event.getDamager() instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            player = (Player)event.getDamager();
            if (player.getInventory().getItemInMainHand().getType() != Material.AIR) {
                ItemStack itemStackHand = player.getInventory().getItemInMainHand();
                PersistentDataContainer pdcHand = this.getPersistentDataContainer(itemStackHand);
                this.hasDamageHandler(event, pdcHand);
            }
            if (event.getEntity().getPersistentDataContainer().has(Keys.GUARDIAN_KEY, PersistentDataType.STRING)) {
                if (Objects.equals(event.getEntity().getPersistentDataContainer().get(Keys.GUARDIAN_KEY, PersistentDataType.STRING), player.getName())) {
                    event.setCancelled(true);
                } else if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), event.getEntity().getLocation(), Interaction.ATTACK_ENTITY)) {
                    event.setCancelled(true);
                }
            }
        }
        if (event.getEntity() instanceof Player) {
            player = (Player)event.getEntity();
            if (player.getInventory().getChestplate() != null) {
                ItemStack itemStackChest = player.getInventory().getChestplate();
                PersistentDataContainer pdcChest = this.getPersistentDataContainer(itemStackChest);
                this.hasDamageHandler(event, pdcChest);
            }
            if (player.getInventory().getHelmet() != null) {
                ItemStack itemStackHelmet = player.getInventory().getHelmet();
                PersistentDataContainer pdcHelmet = this.getPersistentDataContainer(itemStackHelmet);
                this.hasDamageHandler(event, pdcHelmet);
            }
        }
    }

    public void hasDamageHandler(EntityDamageByEntityEvent event, PersistentDataContainer pdc) {
        if (!pdc.isEmpty()) {
            for (NamespacedKey key : pdc.getKeys()) {
                SlimefunItem item;
                if (!pdc.has(key, PersistentDataType.STRING) || !((item = this.getSfItem(key, pdc)) instanceof OnDamageHandler)) continue;
                ((OnDamageHandler)item).onDamage(event);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (event.getBlock().getState() instanceof Container) {
            return;
        }
        if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        PersistentDataContainer pdc = this.getPersistentDataContainer(itemStack);
        this.hasBlockBreakHandler(event, pdc, player);
    }

    public void hasBlockBreakHandler(BlockBreakEvent event, PersistentDataContainer pdc, Player player) {
        if (!pdc.isEmpty()) {
            for (NamespacedKey key : pdc.getKeys()) {
                SlimefunItem item;
                if (!pdc.has(key, PersistentDataType.STRING) || !((item = this.getSfItem(key, pdc)) instanceof OnBlockBreakHandler)) continue;
                ((OnBlockBreakHandler)item).onBlockBreak(event, player);
            }
        }
    }

    @EventHandler
    public void onArrowHit(ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)event.getEntity();
        if (!(arrow.getShooter() instanceof Player)) {
            return;
        }
        if (!(event.getHitEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)event.getHitEntity();
        Player player = (Player)arrow.getShooter();
        if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        PersistentDataContainer pdc = this.getPersistentDataContainer(itemStack);
        this.hasProjectileHandler(event, pdc, player, livingEntity);
    }

    public void hasProjectileHandler(ProjectileHitEvent event, PersistentDataContainer pdc, Player player, LivingEntity livingEntity) {
        if (!pdc.isEmpty()) {
            for (NamespacedKey key : pdc.getKeys()) {
                SlimefunItem item;
                if (!pdc.has(key, PersistentDataType.STRING) || !((item = this.getSfItem(key, pdc)) instanceof OnArrowHitHandler)) continue;
                ((OnArrowHitHandler)item).onArrowHit(event, player, livingEntity);
            }
        }
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        PersistentDataContainer pdc = this.getPersistentDataContainer(itemStack);
        this.hasRightClickHandler(pdc, player);
    }

    public void hasRightClickHandler(PersistentDataContainer pdc, Player player) {
        if (!pdc.isEmpty()) {
            for (NamespacedKey key : pdc.getKeys()) {
                SlimefunItem item;
                if (!pdc.has(key, PersistentDataType.STRING) || !((item = this.getSfItem(key, pdc)) instanceof OnRightClickHandler)) continue;
                ((OnRightClickHandler)item).onRightClick(player);
            }
        }
    }

    @EventHandler
    public void onMobTarget(EntityTargetLivingEntityEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getEntity() instanceof Zombie) {
            Zombie zombieTarget;
            Zombie zombie = (Zombie)event.getEntity();
            if (event.getTarget() instanceof Player) {
                Player player = (Player)event.getTarget();
                if (!zombie.getPersistentDataContainer().has(Keys.GUARDIAN_KEY, PersistentDataType.STRING)) {
                    return;
                }
                if (Objects.equals(zombie.getPersistentDataContainer().get(Keys.GUARDIAN_KEY, PersistentDataType.STRING), player.getName())) {
                    event.setCancelled(true);
                }
                if (TargetReasonEnum.PLAYER_TARGET.isTagged(event.getReason())) {
                    event.setTarget(null);
                    event.setCancelled(true);
                }
            }
            if (event.getTarget() instanceof Zombie && (zombieTarget = (Zombie)event.getTarget()).getPersistentDataContainer().has(Keys.GUARDIAN_KEY, PersistentDataType.STRING) && TargetReasonEnum.ZOMBIE_TARGET.isTagged(event.getReason())) {
                event.setCancelled(true);
            }
        }
    }

    public SlimefunItem getSfItem(NamespacedKey key, PersistentDataContainer pdc) {
        return SlimefunItem.getById((String)Objects.requireNonNull((String)pdc.get(key, PersistentDataType.STRING)));
    }

    public PersistentDataContainer getPersistentDataContainer(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        Validate.notNull((Object)meta, (String)"Meta must not be null!");
        return meta.getPersistentDataContainer();
    }
}

