/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.Staffs;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.Items.FNAmpItems;
import ne.fnfal113.fnamplifications.Multiblock.FnAssemblyStation;
import ne.fnfal113.fnamplifications.Staffs.Interface.EntityStaffImpl;
import ne.fnfal113.fnamplifications.Staffs.MainStaff;
import ne.fnfal113.fnamplifications.Utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class StaffOfLocomotion
extends SlimefunItem
implements EntityStaffImpl {
    private final Map<PersistentDataContainer, LivingEntity> ENTITY_OWNER = new HashMap<PersistentDataContainer, LivingEntity>();
    private static final SlimefunAddon plugin = FNAmplifications.getInstance();
    private final NamespacedKey defaultUsageKey = new NamespacedKey((Plugin)FNAmplifications.getInstance(), "movestaff");
    private final NamespacedKey defaultUsageKey2 = new NamespacedKey((Plugin)FNAmplifications.getInstance(), "identifier");
    private final MainStaff mainStaff = new MainStaff(this.lore(), 10, this.getStorageKey(), this.getItem(), this.getId());

    public StaffOfLocomotion(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int maxUses) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    public NamespacedKey getStorageKey() {
        return this.defaultUsageKey;
    }

    @Nonnull
    public NamespacedKey getStorageKey2() {
        return this.defaultUsageKey2;
    }

    @Override
    public List<String> lore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(0, "");
        lore.add(1, ChatColor.LIGHT_PURPLE + "Move entities to a target location by right");
        lore.add(2, ChatColor.LIGHT_PURPLE + "clicking to select and left click to move");
        return lore;
    }

    @Override
    public void onRightClick(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (!(event.getRightClicked() instanceof LivingEntity) && event.getRightClicked() instanceof Player) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cYou right clicked an invalid entity"));
            return;
        }
        LivingEntity en = (LivingEntity)event.getRightClicked();
        if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), en.getLocation(), Interaction.INTERACT_ENTITY)) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission to select this entity!");
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        PersistentDataContainer data = meta.getPersistentDataContainer();
        PersistentDataContainer max_Uses = meta.getPersistentDataContainer();
        int uses_Left = (Integer)max_Uses.getOrDefault(this.getStorageKey(), PersistentDataType.INTEGER, (Object)FNAmplifications.getInstance().getConfigManager().getValueById(this.getId() + "-max-uses"));
        if (!this.ENTITY_OWNER.containsValue(en)) {
            this.ENTITY_OWNER.remove(data);
            data.set(this.getStorageKey2(), PersistentDataType.DOUBLE, (Object)Math.random());
            this.mainStaff.updateLore(lore);
            lore.add(3, "");
            lore.add(4, ChatColor.YELLOW + "Uses left: " + uses_Left);
            lore.add(5, "");
            lore.add(6, ChatColor.WHITE + "Entity right clicked: " + ChatColor.ITALIC + en.getName());
            lore.add(7, ChatColor.WHITE + "Entity ID: " + ChatColor.ITALIC + en.getEntityId());
            meta.setLore(lore);
            item.setItemMeta(meta);
            this.ENTITY_OWNER.put(data, en);
            Objects.requireNonNull(player.getLocation().getWorld()).playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_MIRROR_MOVE, 1.0f, 1.0f);
        } else {
            player.sendMessage(Utils.colorTranslator("&eThis entity has been right clicked already!"));
        }
    }

    @Override
    public void onLeftClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer data = meta.getPersistentDataContainer();
        Block block = player.getTargetBlockExact(100);
        if (block == null) {
            return;
        }
        if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), block, Interaction.INTERACT_BLOCK)) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission to teleport entity there!");
            return;
        }
        if (this.ENTITY_OWNER.get(data) == null) {
            player.sendMessage("You haven't right clicked an entity or Entity ID changed after server restart");
            return;
        }
        if (this.ENTITY_OWNER.containsKey(data)) {
            LivingEntity entity = this.ENTITY_OWNER.get(data);
            entity.teleport(block.getLocation().add(0.5, 1.0, 0.5));
            this.ENTITY_OWNER.remove(data);
            Objects.requireNonNull(player.getLocation().getWorld()).playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_MIRROR_MOVE, 1.0f, 1.0f);
            this.mainStaff.updateMeta(item, meta, player);
        }
    }

    public static void setup() {
        new StaffOfLocomotion((ItemGroup)FNAmpItems.FN_STAFFS, FNAmpItems.FN_STAFF_LOCOMOTION, FnAssemblyStation.RECIPE_TYPE, new ItemStack[]{SlimefunItems.BLANK_RUNE, SlimefunItems.MAGICAL_GLASS, new SlimefunItemStack(SlimefunItems.ENDER_LUMP_3, 6), SlimefunItems.AIR_RUNE, new ItemStack(Material.BLAZE_ROD), SlimefunItems.AIR_RUNE, new SlimefunItemStack(SlimefunItems.MAGIC_LUMP_3, 6), SlimefunItems.MAGIC_EYE_OF_ENDER, SlimefunItems.BLANK_RUNE}, 10).register(plugin);
    }
}

