/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.Staffs.Implementation;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class AirStriderTask
extends BukkitRunnable {
    private final Map<UUID, Block> blockMap = new HashMap<UUID, Block>();
    private final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();
    private final Player player;

    public AirStriderTask(Player player) {
        this.player = player;
        this.cooldown.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void run() {
        if (this.cooldown.containsKey(this.player.getUniqueId())) {
            long diff = (System.currentTimeMillis() - this.cooldown.get(this.player.getUniqueId())) / 1000L;
            if (diff < 10L) {
                Block newBlock;
                if (this.blockMap.containsKey(this.player.getUniqueId())) {
                    Block block = this.blockMap.get(this.player.getUniqueId());
                    if (block != null) {
                        block.setType(Material.AIR);
                    }
                    this.blockMap.remove(this.player.getUniqueId());
                }
                if ((newBlock = this.player.getLocation().getBlock().getRelative(0, -1, 0)).getType() == Material.AIR) {
                    newBlock.setType(Material.BARRIER);
                    this.blockMap.put(this.player.getUniqueId(), newBlock);
                }
            } else {
                Block block = this.blockMap.get(this.player.getUniqueId());
                if (block != null) {
                    block.setType(Material.AIR);
                }
                this.cooldown.remove(this.player.getUniqueId());
                this.player.sendMessage(ChatColor.LIGHT_PURPLE + "Air Strider has expired!");
            }
        }
    }

    public Map<UUID, Block> getBlockMap() {
        return this.blockMap;
    }

    public Map<UUID, Long> getCooldown() {
        return this.cooldown;
    }

    public Player getPlayer() {
        return this.player;
    }
}

