/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.Gems.Implementation;

import ne.fnfal113.fnamplifications.Utils.Utils;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ReturnWeaponTask
extends BukkitRunnable {
    private final ItemStack itemStack;
    private final ArmorStand armorStand;
    private final Player player;

    public ReturnWeaponTask(ItemStack itemStack, ArmorStand armorStand, Player player) {
        this.itemStack = itemStack;
        this.armorStand = armorStand;
        this.player = player;
    }

    public void run() {
        Location asLocation = this.getArmorStand().getLocation();
        Vector asVector = asLocation.toVector();
        Location pLocation = this.getPlayer().getLocation();
        Vector pVector = pLocation.toVector();
        this.getArmorStand().teleport(asLocation.subtract(asVector.subtract(pVector).normalize()).setDirection(pLocation.getDirection()));
        if (!this.getPlayer().isOnline()) {
            this.dropItem(asLocation);
            this.stopTask();
        }
        if (this.distanceBetween(asLocation, pLocation) > 150.0) {
            Location dropLoc = this.dropItem(asLocation);
            this.getPlayer().sendMessage(Utils.colorTranslator("&cWeapon has not been returned because you're too far!"));
            this.getPlayer().sendMessage(Utils.colorTranslator("&cit was dropped at: &ex: " + (int)dropLoc.getX() + ", y: " + (int)dropLoc.getY() + ", z: " + (int)dropLoc.getZ()));
            this.stopTask();
        }
        if (this.distanceBetween(asLocation, pLocation) < 0.5) {
            if (this.getPlayer().getInventory().firstEmpty() == -1) {
                this.getPlayer().sendMessage(Utils.colorTranslator("&eInventory full! dropped the item instead"));
                this.dropItem(pLocation);
            } else {
                this.getPlayer().getInventory().addItem(new ItemStack[]{this.getItemStack().clone()});
            }
            this.stopTask();
        }
    }

    public Location dropItem(Location location) {
        Item droppedItem = this.getPlayer().getWorld().dropItem(location, this.getItemStack().clone());
        droppedItem.setOwner(this.getPlayer().getUniqueId());
        droppedItem.setGlowing(true);
        return droppedItem.getLocation();
    }

    public double distanceBetween(Location asLoc, Location pLoc) {
        return asLoc.distance(pLoc);
    }

    public void stopTask() {
        this.getArmorStand().remove();
        this.cancel();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public Player getPlayer() {
        return this.player;
    }
}

