/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.Gems;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.ConfigValues.ReturnConfValue;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.Gems.Abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.Gems.Implementation.Gem;
import ne.fnfal113.fnamplifications.Gems.Implementation.GuardianTask;
import ne.fnfal113.fnamplifications.Gems.Implementation.WeaponArmorEnum;
import ne.fnfal113.fnamplifications.Gems.Interface.OnDamageHandler;
import ne.fnfal113.fnamplifications.Items.FNAmpItems;
import ne.fnfal113.fnamplifications.Multiblock.FnGemAltar;
import ne.fnfal113.fnamplifications.Utils.Keys;
import ne.fnfal113.fnamplifications.Utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Flying;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class GuardianGem
extends AbstractGem
implements OnDamageHandler {
    private static final SlimefunAddon plugin = FNAmplifications.getInstance();
    private static final ReturnConfValue value = new ReturnConfValue();
    private final Map<UUID, Zombie> entityUUIDMap = new HashMap<UUID, Zombie>();
    private final Map<UUID, BukkitTask> runnableMap = new HashMap<UUID, BukkitTask>();

    public GuardianGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    public void onDrag(InventoryClickEvent event, Player player) {
        if (event.getCursor() == null) {
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)event.getCursor());
        if (slimefunItem != null && currentItem != null && WeaponArmorEnum.CHESTPLATE.isTagged(currentItem.getType())) {
            ItemMeta meta = currentItem.getItemMeta();
            PersistentDataContainer container = meta.getPersistentDataContainer();
            if (this.checkGemAmount(container, currentItem) < 4) {
                Gem gem = new Gem(slimefunItem, currentItem, player);
                if (!gem.isSameGem(currentItem)) {
                    player.setItemOnCursor(new ItemStack(Material.AIR));
                    gem.socketItem();
                } else {
                    player.sendMessage(Utils.colorTranslator("&6Your item has " + gem.getSfItemName() + " &6socketed already!"));
                }
            } else {
                player.sendMessage(Utils.colorTranslator("&eOnly 4 gems per item is allowed!"));
                player.playSound(player.getLocation(), Sound.UI_TOAST_OUT, 1.0f, 1.0f);
            }
            event.setCancelled(true);
        }
    }

    @Override
    public int checkGemAmount(PersistentDataContainer pdc, ItemStack itemStack) {
        return (Integer)pdc.getOrDefault(new NamespacedKey((Plugin)FNAmplifications.getInstance(), itemStack.getType().toString().toLowerCase() + "_socket_amount"), PersistentDataType.INTEGER, (Object)0);
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (event.getDamager() instanceof Phantom || event.getDamager() instanceof Flying || event.getDamager() instanceof EnderDragon) {
            return;
        }
        if (this.runnableMap.containsKey(player.getUniqueId()) && this.runnableMap.get(player.getUniqueId()).isCancelled()) {
            this.entityUUIDMap.remove(player.getUniqueId());
            this.runnableMap.remove(player.getUniqueId());
            return;
        }
        if (!this.entityUUIDMap.containsKey(player.getUniqueId())) {
            if (ThreadLocalRandom.current().nextInt(100) < value.guardianGem()) {
                GuardianTask guardianTask = new GuardianTask(player, event);
                this.runnableMap.put(player.getUniqueId(), guardianTask.runTaskTimer((Plugin)FNAmplifications.getInstance(), 5L, 3L));
                this.entityUUIDMap.put(player.getUniqueId(), guardianTask.getZombie());
            }
        } else {
            Zombie zombie = this.entityUUIDMap.get(player.getUniqueId());
            if (zombie.getTarget() != null && !zombie.getTarget().isDead()) {
                return;
            }
            if (event.getDamager().getPersistentDataContainer().has(Keys.GUARDIAN_KEY, PersistentDataType.STRING)) {
                zombie.setTarget((LivingEntity)Bukkit.getPlayer((String)((String)event.getDamager().getPersistentDataContainer().get(Keys.GUARDIAN_KEY, PersistentDataType.STRING))));
            } else {
                zombie.setTarget(event.getDamager() instanceof Projectile ? (LivingEntity)((Projectile)event.getDamager()).getShooter() : (LivingEntity)event.getDamager());
            }
        }
    }

    public static void setup() {
        new GuardianGem((ItemGroup)FNAmpItems.FN_GEMS, FNAmpItems.FN_GEM_GUARDIAN, FnGemAltar.RECIPE_TYPE, new ItemStack[]{SlimefunItems.TALISMAN_ANGEL, new SlimefunItemStack(SlimefunItems.BLANK_RUNE, 1), SlimefunItems.TALISMAN_FIRE, new SlimefunItemStack(SlimefunItems.ESSENCE_OF_AFTERLIFE, 1), new ItemStack(Material.EMERALD), new SlimefunItemStack(SlimefunItems.ESSENCE_OF_AFTERLIFE, 1), SlimefunItems.MAGIC_SUGAR, new SlimefunItemStack(SlimefunItems.AIR_RUNE, 1), SlimefunItems.MAGIC_SUGAR}).register(plugin);
    }
}

