/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.Staffs;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class MainStaff {
    private final List<String> defaultLore;
    private final int staffUses;
    private final NamespacedKey storageKey;

    public MainStaff(List<String> lore, int uses, NamespacedKey storageKey) {
        this.defaultLore = lore;
        this.staffUses = uses;
        this.storageKey = storageKey;
    }

    public void updateLore(List<String> lore) {
        for (int i = 0; i < this.getDefaultLore().size(); ++i) {
            lore.add(i, this.getDefaultLore().get(i));
        }
    }

    public void updateMeta(ItemStack item, ItemMeta meta, Player player) {
        PersistentDataContainer max_Uses = meta.getPersistentDataContainer();
        int uses_Left = (Integer)max_Uses.getOrDefault(this.getStorageKey(), PersistentDataType.INTEGER, (Object)this.getStaffUses());
        int decrement = uses_Left - 1;
        ArrayList<String> lore = new ArrayList<String>();
        if (decrement > 0) {
            max_Uses.set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)decrement);
            this.updateLore(lore);
            lore.add("");
            lore.add(ChatColor.YELLOW + "Uses left: " + decrement);
            meta.setLore(lore);
            item.setItemMeta(meta);
        } else {
            player.getInventory().setItemInMainHand(null);
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(meta.getDisplayName() + " &d&lhas reached max uses!")));
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        }
    }

    public List<String> getDefaultLore() {
        return this.defaultLore;
    }

    public int getStaffUses() {
        return this.staffUses;
    }

    public NamespacedKey getStorageKey() {
        return this.storageKey;
    }
}

