/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.Gems.Implementation;

import ne.fnfal113.fnamplifications.Utils.Keys;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GuardianTask
extends BukkitRunnable {
    private Zombie zombie;
    private final Player player;

    public GuardianTask(Player player, EntityDamageByEntityEvent damageByEntityEvent) {
        this.player = player;
        this.spawnZombie(damageByEntityEvent);
    }

    public void run() {
        if (this.getZombie().getTarget() == null) {
            Vector vec = this.getPlayer().getLocation().getDirection();
            Vector finalVec = vec.clone().setX(-vec.getZ()).setZ(vec.getX()).setY(0.8);
            this.getZombie().teleport(this.getPlayer().getLocation().add(finalVec.multiply(1)));
        }
        if (this.getZombie().isDead() || this.getZombie().isInWater() || !this.getPlayer().isOnline() || this.getPlayer().getEquipment().getChestplate() == null) {
            this.getZombie().remove();
            this.cancel();
        }
    }

    public void spawnZombie(EntityDamageByEntityEvent event) {
        this.zombie = (Zombie)this.getPlayer().getWorld().spawn(this.getPlayer().getLocation(), Zombie.class);
        this.getZombie().setCustomName(this.getPlayer().getName() + "'s Guardian");
        this.getZombie().setCustomNameVisible(true);
        this.getZombie().setGlowing(true);
        this.getZombie().setAI(true);
        this.getZombie().setBaby();
        this.getZombie().getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue((double)0.4f);
        this.getZombie().getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(40.0);
        this.getZombie().getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(7.0);
        this.getZombie().getEquipment().setHelmet(new ItemStack(Material.GOLDEN_HELMET));
        this.getZombie().getEquipment().setChestplate(new ItemStack(Material.DIAMOND_CHESTPLATE));
        this.getZombie().getEquipment().setLeggings(new ItemStack(Material.DIAMOND_LEGGINGS));
        this.getZombie().getEquipment().setBoots(new ItemStack(Material.GOLDEN_BOOTS));
        this.getZombie().getEquipment().setItemInMainHand(new ItemStack(Material.DIAMOND_SWORD));
        this.getZombie().addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, Integer.MAX_VALUE, 0, false, false, false));
        this.getZombie().setHealth(40.0);
        this.getZombie().getPersistentDataContainer().set(Keys.GUARDIAN_KEY, PersistentDataType.STRING, (Object)this.player.getName());
        this.getZombie().setPersistent(false);
        this.getZombie().setRemoveWhenFarAway(true);
        if (event.getDamager().getPersistentDataContainer().has(Keys.GUARDIAN_KEY, PersistentDataType.STRING)) {
            this.getZombie().setTarget((LivingEntity)Bukkit.getPlayer((String)((String)event.getDamager().getPersistentDataContainer().get(Keys.GUARDIAN_KEY, PersistentDataType.STRING))));
        } else {
            this.getZombie().setTarget(event.getDamager() instanceof Projectile ? (LivingEntity)((Projectile)event.getDamager()).getShooter() : (LivingEntity)event.getDamager());
        }
    }

    public Zombie getZombie() {
        return this.zombie;
    }

    public Player getPlayer() {
        return this.player;
    }
}

