/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.MysteriousItems;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MainStick {
    public final NamespacedKey storageKey;
    public final NamespacedKey storageKey2;
    public final Map<Enchantment, Integer> enchantmentMap;
    public final String weaponLore;
    public final String stickLore;
    public final List<String> effects;

    public MainStick(NamespacedKey key1, NamespacedKey key2, Map<Enchantment, Integer> enchantmentMap, String weaponLore, String stickLore) {
        this(key1, key2, enchantmentMap, weaponLore, stickLore, null);
    }

    public MainStick(NamespacedKey key1, NamespacedKey key2, Map<Enchantment, Integer> enchantmentMap, String weaponLore, String stickLore, List<String> effects) {
        this.storageKey = key1;
        this.storageKey2 = key2;
        this.enchantmentMap = enchantmentMap;
        this.weaponLore = weaponLore;
        this.stickLore = stickLore;
        this.effects = effects;
    }

    public void onInteract(PlayerInteractEvent e, Material material, boolean withEffects) {
        Player player = e.getPlayer();
        ItemStack item1 = player.getInventory().getItemInMainHand();
        ItemMeta meta = item1.getItemMeta();
        List lore2 = meta.getLore();
        NamespacedKey key = this.getStorageKey();
        NamespacedKey key2 = this.getStorageKey2();
        PersistentDataContainer expUsed = meta.getPersistentDataContainer();
        PersistentDataContainer damageAmount = meta.getPersistentDataContainer();
        int xpamount = (Integer)expUsed.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
        int damageAll = (Integer)damageAmount.getOrDefault(key2, PersistentDataType.INTEGER, (Object)0);
        this.getEnchantmentMap().forEach((Key, Value) -> meta.addEnchant(Key, Value.intValue(), true));
        meta.setUnbreakable(true);
        meta.setLore(this.loreUpdate(lore2, damageAll, xpamount, this.weaponLore, withEffects));
        item1.setItemMeta(meta);
        if (item1.getType() != material) {
            item1.setType(material);
            player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_MIRROR_MOVE, 1.0f, 1.0f);
            player.getWorld().playEffect(player.getLocation().add(0.3, 0.4, 0.45), Effect.ENDER_SIGNAL, 1);
            player.getWorld().spawnParticle(Particle.FLASH, player.getLocation().add(0.3, 0.4, 0.45), 2, 0.1, 0.1, 0.1, 0.1);
        }
    }

    public void levelChange(PlayerLevelChangeEvent event, SlimefunItemStack slimefunItem, int level, int incrementLevel) {
        Player p = event.getPlayer();
        ItemStack item = p.getInventory().getItemInMainHand();
        if (event.getOldLevel() > event.getNewLevel() && p.getLevel() > level) {
            this.transformWeapon(p, item, slimefunItem, level, this.weaponLore, incrementLevel);
        }
    }

    public void transformWeapon(Player p, ItemStack item, SlimefunItemStack slimefunItem, int level, String finalLore, int incrementLevel) {
        CustomItemStack item2 = new CustomItemStack((ItemStack)slimefunItem);
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        PersistentDataContainer expUsed = meta.getPersistentDataContainer();
        PersistentDataContainer damage = meta.getPersistentDataContainer();
        int xpAmount = (Integer)expUsed.getOrDefault(this.getStorageKey(), PersistentDataType.INTEGER, (Object)0);
        int damageAmount = (Integer)damage.getOrDefault(this.getStorageKey2(), PersistentDataType.INTEGER, (Object)0);
        int amount = ++xpAmount + incrementLevel;
        expUsed.set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)amount);
        meta.setLore(this.loreUpdate(lore, damageAmount, amount, finalLore, false));
        item.setItemMeta(meta);
        if (p.getLevel() <= level) {
            if (lore.size() >= 4) {
                lore.subList(3, lore.size()).clear();
            }
            meta.setLore(lore);
            this.getEnchantmentMap().forEach((Key, Value) -> meta.removeEnchant(Key));
            item.setItemMeta(meta);
            item.setType(item2.getType());
        }
    }

    public List<String> loreUpdate(List<String> lore2, int get_Damage, int xpamount, String lore, boolean withEffects) {
        if (lore2.size() == 1) {
            lore2.remove(0);
            lore2.add(lore);
            lore2.add(ChatColor.YELLOW + "Exp Levels Consumed: " + ChatColor.WHITE + xpamount);
            lore2.add(ChatColor.YELLOW + "Total Damage inflicted: " + ChatColor.WHITE + get_Damage);
        } else {
            lore2.set(0, lore);
            lore2.set(1, ChatColor.YELLOW + "Exp Levels Consumed: " + ChatColor.WHITE + xpamount);
            lore2.set(2, ChatColor.YELLOW + "Total Damage inflicted: " + ChatColor.WHITE + get_Damage);
        }
        if (withEffects && lore2.size() < 4) {
            lore2.addAll(this.getEffects());
        }
        return lore2;
    }

    public void darkenVision(Player player, int level) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 300, 2, false, false));
        player.sendTitle(ChatColor.DARK_RED + "Your vision darkens!", ChatColor.RED + "The stick is unpredictable", 45, 120, 135);
        player.sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "[FNAmpli" + ChatColor.AQUA + "" + ChatColor.BOLD + "fications] > " + ChatColor.YELLOW + "You're too weak, make sure your exp level is higher than " + level);
    }

    public NamespacedKey getStorageKey() {
        return this.storageKey;
    }

    public NamespacedKey getStorageKey2() {
        return this.storageKey2;
    }

    public Map<Enchantment, Integer> getEnchantmentMap() {
        return this.enchantmentMap;
    }

    public String getWeaponLore() {
        return this.weaponLore;
    }

    public String getStickLore() {
        return this.stickLore;
    }

    public List<String> getEffects() {
        return this.effects;
    }
}

