/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.Gems.Implementation;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.Utils.Utils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Gem {
    private final SlimefunItem slimefunItem;
    private final ItemStack itemStack;
    private final String sfItemName;
    private final String gemID;
    private final Player player;
    private final NamespacedKey key1;
    private final NamespacedKey key2;

    @ParametersAreNonnullByDefault
    public Gem(SlimefunItem sfItem, ItemStack itemToSocket, Player p) {
        this.slimefunItem = sfItem;
        this.itemStack = itemToSocket;
        this.sfItemName = sfItem.getItemName();
        this.gemID = sfItem.getId();
        this.player = p;
        this.key1 = new NamespacedKey((Plugin)FNAmplifications.getInstance(), sfItem.getId().toLowerCase());
        this.key2 = new NamespacedKey((Plugin)FNAmplifications.getInstance(), itemToSocket.getType().toString().toLowerCase() + "_socket_amount");
    }

    public String getSfItemName() {
        return this.sfItemName;
    }

    public SlimefunItem getSlimefunItem() {
        return this.slimefunItem;
    }

    public ItemStack getSocketedItemStack() {
        return this.itemStack;
    }

    public String getGemID() {
        return this.gemID;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Nonnull
    protected NamespacedKey getStorageKey1() {
        return this.key1;
    }

    @Nonnull
    protected NamespacedKey getStorageKey2() {
        return this.key2;
    }

    public void socketItem() {
        String name = this.getSfItemName();
        ItemStack itemStack = this.getSocketedItemStack();
        ItemMeta meta = itemStack.getItemMeta();
        Validate.notNull((Object)meta, (String)"Meta must not be null!");
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        int amountOfGems = (Integer)pdc.getOrDefault(this.getStorageKey2(), PersistentDataType.INTEGER, (Object)0);
        if (amountOfGems == 0) {
            ArrayList<String> lore = meta.hasLore() ? meta.getLore() : new ArrayList<String>();
            lore.add("");
            lore.add(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4| &d&lGems &c|\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5"));
            lore.add(ChatColor.RED + "\u25ec " + name);
            lore.add(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4&c\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5"));
            meta.setLore(lore);
        } else {
            List lore2 = meta.getLore();
            if (lore2 != null) {
                for (int i = 0; i < lore2.size(); ++i) {
                    if (!((String)lore2.get(i)).startsWith(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4| &d&lGems &c|\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5"))) continue;
                    lore2.add(i + 1, ChatColor.RED + "\u25ec " + name);
                }
                meta.setLore(lore2);
            }
        }
        pdc.set(this.getStorageKey1(), PersistentDataType.STRING, (Object)this.getGemID());
        pdc.set(this.getStorageKey2(), PersistentDataType.INTEGER, (Object)(amountOfGems + 1));
        itemStack.setItemMeta(meta);
        this.getPlayer().sendMessage(Utils.colorTranslator("&eSuccessfully bound " + name + " &eto " + itemStack.getType().name().replace("_", " ").toLowerCase(Locale.ROOT).replace(itemStack.getType().name().substring(0, 0).toLowerCase(Locale.ROOT), itemStack.getType().name().substring(0, 0).toUpperCase(Locale.ROOT))));
        this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_BLAZE_SHOOT, 1.0f, 1.0f);
    }

    public boolean isSameGem(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.isEmpty()) {
            return false;
        }
        return container.has(this.getStorageKey1(), PersistentDataType.STRING);
    }

    public void retaliateWeapon() {
        ItemMeta meta = this.getSocketedItemStack().getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)FNAmplifications.getInstance(), "return_weapon"), PersistentDataType.STRING, (Object)"true");
        this.getSocketedItemStack().setItemMeta(meta);
    }
}

